// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3;

import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.ValidationResult;

/**
 * Base class for requests that are paginated and sorted
 */
public abstract class PaginatedAndSortedRequest extends PaginatedRequest {
    
    /**
     * The order by
     *
     * @param orderBy the order by
     */
    private final String orderBy;

    protected PaginatedAndSortedRequest(Integer page, Integer perPage, String orderBy) {
        super(page, perPage);
        this.orderBy = orderBy;
    }

    /**
     * Returns whether a {@link PaginatedAndSortedRequest} instance is valid
     *
     * @return a result indicating whether an instance is valid, and messages about what is wrong if it is invalid
     */
    protected final ValidationResult.ValidationResultBuilder isPaginatedAndSortedRequestValid() {
        return isPaginatedRequestValid();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaginatedAndSortedRequest)) return false;
        final PaginatedAndSortedRequest other = (PaginatedAndSortedRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$orderBy = this.getOrderBy();
        final java.lang.Object other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !this$orderBy.equals(other$orderBy)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaginatedAndSortedRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $orderBy = this.getOrderBy();
        result = result * PRIME + ($orderBy == null ? 43 : $orderBy.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "PaginatedAndSortedRequest(super=" + super.toString() + ", orderBy=" + this.getOrderBy() + ")";
    }

    /**
     * The order by
     *
     * @return the order by
     */
    @QueryParameter("order_by")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrderBy() {
        return this.orderBy;
    }
}