// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3;

import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.ValidationResult;

/**
 * Base class for requests that are paginated
 */
public abstract class PaginatedRequest {
    
    /**
     * The page
     *
     * @param page the page
     */
    private final Integer page;
    
    /**
     * The results per page
     *
     * @param perPage the results per page
     */
    private final Integer perPage;

    protected PaginatedRequest(Integer page, Integer perPage) {
        this.page = page;
        this.perPage = perPage;
    }

    /**
     * Returns whether a {@link PaginatedRequest} instance is valid
     *
     * @return a result indicating whether an instance is valid, and messages about what is wrong if it is invalid
     */
    protected final ValidationResult.ValidationResultBuilder isPaginatedRequestValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.page != null && this.page < 1) {
            builder.message("page must be greater than or equal to 1");
        }
        if (this.perPage != null && (this.perPage < 1 || this.perPage > 5000)) {
            builder.message("perPage must be between 1 and 5000 inclusive");
        }
        return builder;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaginatedRequest)) return false;
        final PaginatedRequest other = (PaginatedRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        final java.lang.Object this$page = this.getPage();
        final java.lang.Object other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) return false;
        final java.lang.Object this$perPage = this.getPerPage();
        final java.lang.Object other$perPage = other.getPerPage();
        if (this$perPage == null ? other$perPage != null : !this$perPage.equals(other$perPage)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaginatedRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $page = this.getPage();
        result = result * PRIME + ($page == null ? 43 : $page.hashCode());
        final java.lang.Object $perPage = this.getPerPage();
        result = result * PRIME + ($perPage == null ? 43 : $perPage.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "PaginatedRequest(page=" + this.getPage() + ", perPage=" + this.getPerPage() + ")";
    }

    /**
     * The page
     *
     * @return the page
     */
    @QueryParameter("page")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getPage() {
        return this.page;
    }

    /**
     * The results per page
     *
     * @return the results per page
     */
    @QueryParameter("per_page")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getPerPage() {
        return this.perPage;
    }
}