// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Singular;
import java.util.List;

/**
 * Base class for requests that are paginated
 *
 * @param <T> the entity type
 */
public abstract class PaginatedResponse<T> {
    
    /**
     * The pagination
     *
     * @param pagination the pagination
     */
    private final Pagination pagination;
    
    /**
     * The resources
     *
     * @param resources the resources
     */
    private final List<T> resources;

    protected PaginatedResponse(@JsonProperty("pagination") Pagination pagination, @JsonProperty("resources") @Singular List<T> resources) {
        this.pagination = pagination;
        this.resources = resources;
    }

    public static final class Pagination {
        /**
         * The first
         *
         * @param first the first
         * @return the first
         */
        private final Link first;
        /**
         * The last
         *
         * @param last the last
         * @return the last
         */
        private final Link last;
        /**
         * The next
         *
         * @param next the next
         * @return the next
         */
        private final Link next;
        /**
         * The previous
         *
         * @param previous the previous
         * @return the previous
         */
        private final Link previous;
        /**
         * The total results
         *
         * @param totalResults the total results
         * @return the total results
         */
        private final Integer totalResults;

        Pagination(@JsonProperty("first") Link first, @JsonProperty("last") Link last, @JsonProperty("next") Link next, @JsonProperty("previous") Link previous, @JsonProperty("total_results") Integer totalResults) {
            this.first = first;
            this.last = last;
            this.next = next;
            this.previous = previous;
            this.totalResults = totalResults;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static class PaginationBuilder {
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private Link first;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private Link last;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private Link next;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private Link previous;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private Integer totalResults;

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            PaginationBuilder() {
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public PaginationBuilder first(final Link first) {
                this.first = first;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public PaginationBuilder last(final Link last) {
                this.last = last;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public PaginationBuilder next(final Link next) {
                this.next = next;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public PaginationBuilder previous(final Link previous) {
                this.previous = previous;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public PaginationBuilder totalResults(final Integer totalResults) {
                this.totalResults = totalResults;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public Pagination build() {
                return new Pagination(first, last, next, previous, totalResults);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public java.lang.String toString() {
                return "PaginatedResponse.Pagination.PaginationBuilder(first=" + this.first + ", last=" + this.last + ", next=" + this.next + ", previous=" + this.previous + ", totalResults=" + this.totalResults + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static PaginationBuilder builder() {
            return new PaginationBuilder();
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public Link getFirst() {
            return this.first;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public Link getLast() {
            return this.last;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public Link getNext() {
            return this.next;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public Link getPrevious() {
            return this.previous;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public Integer getTotalResults() {
            return this.totalResults;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof PaginatedResponse.Pagination)) return false;
            final Pagination other = (Pagination)o;
            final java.lang.Object this$first = this.getFirst();
            final java.lang.Object other$first = other.getFirst();
            if (this$first == null ? other$first != null : !this$first.equals(other$first)) return false;
            final java.lang.Object this$last = this.getLast();
            final java.lang.Object other$last = other.getLast();
            if (this$last == null ? other$last != null : !this$last.equals(other$last)) return false;
            final java.lang.Object this$next = this.getNext();
            final java.lang.Object other$next = other.getNext();
            if (this$next == null ? other$next != null : !this$next.equals(other$next)) return false;
            final java.lang.Object this$previous = this.getPrevious();
            final java.lang.Object other$previous = other.getPrevious();
            if (this$previous == null ? other$previous != null : !this$previous.equals(other$previous)) return false;
            final java.lang.Object this$totalResults = this.getTotalResults();
            final java.lang.Object other$totalResults = other.getTotalResults();
            if (this$totalResults == null ? other$totalResults != null : !this$totalResults.equals(other$totalResults)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $first = this.getFirst();
            result = result * PRIME + ($first == null ? 43 : $first.hashCode());
            final java.lang.Object $last = this.getLast();
            result = result * PRIME + ($last == null ? 43 : $last.hashCode());
            final java.lang.Object $next = this.getNext();
            result = result * PRIME + ($next == null ? 43 : $next.hashCode());
            final java.lang.Object $previous = this.getPrevious();
            result = result * PRIME + ($previous == null ? 43 : $previous.hashCode());
            final java.lang.Object $totalResults = this.getTotalResults();
            result = result * PRIME + ($totalResults == null ? 43 : $totalResults.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "PaginatedResponse.Pagination(first=" + this.getFirst() + ", last=" + this.getLast() + ", next=" + this.getNext() + ", previous=" + this.getPrevious() + ", totalResults=" + this.getTotalResults() + ")";
        }
    }

    /**
     * The pagination
     *
     * @return the pagination
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Pagination getPagination() {
        return this.pagination;
    }

    /**
     * The resources
     *
     * @return the resources
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<T> getResources() {
        return this.resources;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaginatedResponse)) return false;
        final PaginatedResponse<?> other = (PaginatedResponse<?>)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        final java.lang.Object this$pagination = this.getPagination();
        final java.lang.Object other$pagination = other.getPagination();
        if (this$pagination == null ? other$pagination != null : !this$pagination.equals(other$pagination)) return false;
        final java.lang.Object this$resources = this.getResources();
        final java.lang.Object other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaginatedResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $pagination = this.getPagination();
        result = result * PRIME + ($pagination == null ? 43 : $pagination.hashCode());
        final java.lang.Object $resources = this.getResources();
        result = result * PRIME + ($resources == null ? 43 : $resources.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "PaginatedResponse(pagination=" + this.getPagination() + ", resources=" + this.getResources() + ")";
    }
}