// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Singular;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Link;
import java.util.Map;

public abstract class Application {
    
    /**
     * When the application was created
     *
     * @param createdAt when the application was created
     */
    private final String createdAt;
    
    /**
     * The desired state
     *
     * @param desiredState the desired state
     */
    private final String desiredState;
    
    /**
     * The environment variables
     *
     * @param environmentVariables the environment variables
     */
    private final Map<String, String> environmentVariables;
    
    /**
     * The id
     *
     * @param id the id
     */
    private final String id;
    
    /**
     * The lifecycle
     *
     * @param lifecycle the lifecycle
     */
    private final Lifecycle lifecycle;
    
    /**
     * The links
     *
     * @param links the links
     */
    private final Map<String, Link> links;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The total desired instances
     *
     * @param totalDesiredInstances the total desired instances
     */
    private final Integer totalDesiredInstances;
    
    /**
     * When the application was updated
     *
     * @param updatedAt when the application was updated
     */
    private final String updatedAt;

    Application(@JsonProperty("created_at") String createdAt, @JsonProperty("desired_state") String desiredState, @JsonProperty("environment_variables") @Singular Map<String, String> environmentVariables, @JsonProperty("guid") String id, @JsonProperty("lifecycle") Lifecycle lifecycle, @JsonProperty("links") @Singular Map<String, Link> links, @JsonProperty("name") String name, @JsonProperty("total_desired_instances") Integer totalDesiredInstances, @JsonProperty("updated_at") String updatedAt) {
        this.createdAt = createdAt;
        this.desiredState = desiredState;
        this.environmentVariables = environmentVariables;
        this.id = id;
        this.links = links;
        this.lifecycle = lifecycle;
        this.name = name;
        this.totalDesiredInstances = totalDesiredInstances;
        this.updatedAt = updatedAt;
    }

    /**
     * When the application was created
     *
     * @return when the application was created
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getCreatedAt() {
        return this.createdAt;
    }

    /**
     * The desired state
     *
     * @return the desired state
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDesiredState() {
        return this.desiredState;
    }

    /**
     * The environment variables
     *
     * @return the environment variables
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    /**
     * The id
     *
     * @return the id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getId() {
        return this.id;
    }

    /**
     * The lifecycle
     *
     * @return the lifecycle
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    /**
     * The links
     *
     * @return the links
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    /**
     * The name
     *
     * @return the name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The total desired instances
     *
     * @return the total desired instances
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getTotalDesiredInstances() {
        return this.totalDesiredInstances;
    }

    /**
     * When the application was updated
     *
     * @return when the application was updated
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Application)) return false;
        final Application other = (Application)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        final java.lang.Object this$createdAt = this.getCreatedAt();
        final java.lang.Object other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) return false;
        final java.lang.Object this$desiredState = this.getDesiredState();
        final java.lang.Object other$desiredState = other.getDesiredState();
        if (this$desiredState == null ? other$desiredState != null : !this$desiredState.equals(other$desiredState)) return false;
        final java.lang.Object this$environmentVariables = this.getEnvironmentVariables();
        final java.lang.Object other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !this$environmentVariables.equals(other$environmentVariables)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$lifecycle = this.getLifecycle();
        final java.lang.Object other$lifecycle = other.getLifecycle();
        if (this$lifecycle == null ? other$lifecycle != null : !this$lifecycle.equals(other$lifecycle)) return false;
        final java.lang.Object this$links = this.getLinks();
        final java.lang.Object other$links = other.getLinks();
        if (this$links == null ? other$links != null : !this$links.equals(other$links)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$totalDesiredInstances = this.getTotalDesiredInstances();
        final java.lang.Object other$totalDesiredInstances = other.getTotalDesiredInstances();
        if (this$totalDesiredInstances == null ? other$totalDesiredInstances != null : !this$totalDesiredInstances.equals(other$totalDesiredInstances)) return false;
        final java.lang.Object this$updatedAt = this.getUpdatedAt();
        final java.lang.Object other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Application;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $createdAt = this.getCreatedAt();
        result = result * PRIME + ($createdAt == null ? 43 : $createdAt.hashCode());
        final java.lang.Object $desiredState = this.getDesiredState();
        result = result * PRIME + ($desiredState == null ? 43 : $desiredState.hashCode());
        final java.lang.Object $environmentVariables = this.getEnvironmentVariables();
        result = result * PRIME + ($environmentVariables == null ? 43 : $environmentVariables.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $lifecycle = this.getLifecycle();
        result = result * PRIME + ($lifecycle == null ? 43 : $lifecycle.hashCode());
        final java.lang.Object $links = this.getLinks();
        result = result * PRIME + ($links == null ? 43 : $links.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $totalDesiredInstances = this.getTotalDesiredInstances();
        result = result * PRIME + ($totalDesiredInstances == null ? 43 : $totalDesiredInstances.hashCode());
        final java.lang.Object $updatedAt = this.getUpdatedAt();
        result = result * PRIME + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "Application(createdAt=" + this.getCreatedAt() + ", desiredState=" + this.getDesiredState() + ", environmentVariables=" + this.getEnvironmentVariables() + ", id=" + this.getId() + ", lifecycle=" + this.getLifecycle() + ", links=" + this.getLinks() + ", name=" + this.getName() + ", totalDesiredInstances=" + this.getTotalDesiredInstances() + ", updatedAt=" + this.getUpdatedAt() + ")";
    }
}