// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Get Task endpoint
 */
public final class GetApplicationTaskRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * The task taskId
     *
     * @param taskId the task id
     */
    private final String taskId;

    GetApplicationTaskRequest(String applicationId, String taskId) {
        this.applicationId = applicationId;
        this.taskId = taskId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.taskId == null) {
            builder.message("task id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class GetApplicationTaskRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String taskId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        GetApplicationTaskRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetApplicationTaskRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetApplicationTaskRequestBuilder taskId(final String taskId) {
            this.taskId = taskId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetApplicationTaskRequest build() {
            return new GetApplicationTaskRequest(applicationId, taskId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "GetApplicationTaskRequest.GetApplicationTaskRequestBuilder(applicationId=" + this.applicationId + ", taskId=" + this.taskId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static GetApplicationTaskRequestBuilder builder() {
        return new GetApplicationTaskRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GetApplicationTaskRequest)) return false;
        final GetApplicationTaskRequest other = (GetApplicationTaskRequest)o;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$taskId = this.getTaskId();
        final java.lang.Object other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $taskId = this.getTaskId();
        result = result * PRIME + ($taskId == null ? 43 : $taskId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "GetApplicationTaskRequest(applicationId=" + this.getApplicationId() + ", taskId=" + this.getTaskId() + ")";
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * The task taskId
     *
     * @return the task id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getTaskId() {
        return this.taskId;
    }
}