// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.FilterParameter;
import org.cloudfoundry.client.v3.PaginatedAndSortedRequest;
import java.util.List;

/**
 * The request payload for the List Application Droplets operation
 */
public final class ListApplicationDropletsRequest extends PaginatedAndSortedRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * The states
     *
     * @param states the states
     */
    private final List<String> states;

    ListApplicationDropletsRequest(Integer page, Integer perPage, String orderBy, String applicationId, List<String> states) {
        super(page, perPage, orderBy);
        this.applicationId = applicationId;
        this.states = states;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = isPaginatedAndSortedRequestValid();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListApplicationDropletsRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer perPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String orderBy;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> states;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListApplicationDropletsRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationDropletsRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationDropletsRequestBuilder perPage(final Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationDropletsRequestBuilder orderBy(final String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationDropletsRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationDropletsRequestBuilder state(final String state) {
            if (this.states == null) this.states = new java.util.ArrayList<String>();
            this.states.add(state);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationDropletsRequestBuilder states(final java.util.Collection<? extends String> states) {
            if (this.states == null) this.states = new java.util.ArrayList<String>();
            this.states.addAll(states);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationDropletsRequest build() {
            java.util.List<String> states;
            switch (this.states == null ? 0 : this.states.size()) {
            case 0: 
                states = java.util.Collections.emptyList();
                break;
            
            case 1: 
                states = java.util.Collections.singletonList(this.states.get(0));
                break;
            
            default: 
                states = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.states));
            
            }
            return new ListApplicationDropletsRequest(page, perPage, orderBy, applicationId, states);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListApplicationDropletsRequest.ListApplicationDropletsRequestBuilder(page=" + this.page + ", perPage=" + this.perPage + ", orderBy=" + this.orderBy + ", applicationId=" + this.applicationId + ", states=" + this.states + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListApplicationDropletsRequestBuilder builder() {
        return new ListApplicationDropletsRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListApplicationDropletsRequest)) return false;
        final ListApplicationDropletsRequest other = (ListApplicationDropletsRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$states = this.getStates();
        final java.lang.Object other$states = other.getStates();
        if (this$states == null ? other$states != null : !this$states.equals(other$states)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListApplicationDropletsRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $states = this.getStates();
        result = result * PRIME + ($states == null ? 43 : $states.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListApplicationDropletsRequest(super=" + super.toString() + ", applicationId=" + this.getApplicationId() + ", states=" + this.getStates() + ")";
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * The states
     *
     * @return states
     */
    @FilterParameter("state")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getStates() {
        return this.states;
    }
}