// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.PaginatedRequest;

/**
 * The request payload for the List Application Tasks operation
 */
public final class ListApplicationTasksRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;

    ListApplicationTasksRequest(Integer page, Integer perPage, String applicationId) {
        super(page, perPage);
        this.applicationId = applicationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = isPaginatedRequestValid();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListApplicationTasksRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer perPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListApplicationTasksRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationTasksRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationTasksRequestBuilder perPage(final Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationTasksRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationTasksRequest build() {
            return new ListApplicationTasksRequest(page, perPage, applicationId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListApplicationTasksRequest.ListApplicationTasksRequestBuilder(page=" + this.page + ", perPage=" + this.perPage + ", applicationId=" + this.applicationId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListApplicationTasksRequestBuilder builder() {
        return new ListApplicationTasksRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListApplicationTasksRequest)) return false;
        final ListApplicationTasksRequest other = (ListApplicationTasksRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListApplicationTasksRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListApplicationTasksRequest(super=" + super.toString() + ", applicationId=" + this.getApplicationId() + ")";
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }
}