// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.applications;

import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.FilterParameter;
import org.cloudfoundry.client.v3.PaginatedAndSortedRequest;
import java.util.List;

/**
 * The request payload for the List Applications operation
 */
public final class ListApplicationsRequest extends PaginatedAndSortedRequest implements Validatable {
    
    /**
     * The ids
     *
     * @param ids the ids
     */
    private final List<String> ids;
    
    /**
     * The names
     *
     * @param names the names
     */
    private final List<String> names;
    
    /**
     * The organization ids
     *
     * @param organizationIds the organization ids
     */
    private final List<String> organizationIds;
    
    /**
     * The space ids
     *
     * @param spaceIds the space ids
     */
    private final List<String> spaceIds;

    ListApplicationsRequest(Integer page, Integer perPage, String orderBy, List<String> ids, List<String> names, List<String> organizationIds, List<String> spaceIds) {
        super(page, perPage, orderBy);
        this.ids = ids;
        this.names = names;
        this.organizationIds = organizationIds;
        this.spaceIds = spaceIds;
    }

    @Override
    public ValidationResult isValid() {
        return isPaginatedAndSortedRequestValid().build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListApplicationsRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer perPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String orderBy;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> ids;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> names;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> organizationIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> spaceIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListApplicationsRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationsRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationsRequestBuilder perPage(final Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationsRequestBuilder orderBy(final String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationsRequestBuilder id(final String id) {
            if (this.ids == null) this.ids = new java.util.ArrayList<String>();
            this.ids.add(id);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationsRequestBuilder ids(final java.util.Collection<? extends String> ids) {
            if (this.ids == null) this.ids = new java.util.ArrayList<String>();
            this.ids.addAll(ids);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationsRequestBuilder name(final String name) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.add(name);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationsRequestBuilder names(final java.util.Collection<? extends String> names) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.addAll(names);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationsRequestBuilder organizationId(final String organizationId) {
            if (this.organizationIds == null) this.organizationIds = new java.util.ArrayList<String>();
            this.organizationIds.add(organizationId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationsRequestBuilder organizationIds(final java.util.Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) this.organizationIds = new java.util.ArrayList<String>();
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationsRequestBuilder spaceId(final String spaceId) {
            if (this.spaceIds == null) this.spaceIds = new java.util.ArrayList<String>();
            this.spaceIds.add(spaceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationsRequestBuilder spaceIds(final java.util.Collection<? extends String> spaceIds) {
            if (this.spaceIds == null) this.spaceIds = new java.util.ArrayList<String>();
            this.spaceIds.addAll(spaceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationsRequest build() {
            java.util.List<String> ids;
            switch (this.ids == null ? 0 : this.ids.size()) {
            case 0: 
                ids = java.util.Collections.emptyList();
                break;
            
            case 1: 
                ids = java.util.Collections.singletonList(this.ids.get(0));
                break;
            
            default: 
                ids = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.ids));
            
            }
            java.util.List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
            case 0: 
                names = java.util.Collections.emptyList();
                break;
            
            case 1: 
                names = java.util.Collections.singletonList(this.names.get(0));
                break;
            
            default: 
                names = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.names));
            
            }
            java.util.List<String> organizationIds;
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
            case 0: 
                organizationIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                organizationIds = java.util.Collections.singletonList(this.organizationIds.get(0));
                break;
            
            default: 
                organizationIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.organizationIds));
            
            }
            java.util.List<String> spaceIds;
            switch (this.spaceIds == null ? 0 : this.spaceIds.size()) {
            case 0: 
                spaceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                spaceIds = java.util.Collections.singletonList(this.spaceIds.get(0));
                break;
            
            default: 
                spaceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.spaceIds));
            
            }
            return new ListApplicationsRequest(page, perPage, orderBy, ids, names, organizationIds, spaceIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListApplicationsRequest.ListApplicationsRequestBuilder(page=" + this.page + ", perPage=" + this.perPage + ", orderBy=" + this.orderBy + ", ids=" + this.ids + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", spaceIds=" + this.spaceIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListApplicationsRequestBuilder builder() {
        return new ListApplicationsRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListApplicationsRequest)) return false;
        final ListApplicationsRequest other = (ListApplicationsRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$ids = this.getIds();
        final java.lang.Object other$ids = other.getIds();
        if (this$ids == null ? other$ids != null : !this$ids.equals(other$ids)) return false;
        final java.lang.Object this$names = this.getNames();
        final java.lang.Object other$names = other.getNames();
        if (this$names == null ? other$names != null : !this$names.equals(other$names)) return false;
        final java.lang.Object this$organizationIds = this.getOrganizationIds();
        final java.lang.Object other$organizationIds = other.getOrganizationIds();
        if (this$organizationIds == null ? other$organizationIds != null : !this$organizationIds.equals(other$organizationIds)) return false;
        final java.lang.Object this$spaceIds = this.getSpaceIds();
        final java.lang.Object other$spaceIds = other.getSpaceIds();
        if (this$spaceIds == null ? other$spaceIds != null : !this$spaceIds.equals(other$spaceIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListApplicationsRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $ids = this.getIds();
        result = result * PRIME + ($ids == null ? 43 : $ids.hashCode());
        final java.lang.Object $names = this.getNames();
        result = result * PRIME + ($names == null ? 43 : $names.hashCode());
        final java.lang.Object $organizationIds = this.getOrganizationIds();
        result = result * PRIME + ($organizationIds == null ? 43 : $organizationIds.hashCode());
        final java.lang.Object $spaceIds = this.getSpaceIds();
        result = result * PRIME + ($spaceIds == null ? 43 : $spaceIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListApplicationsRequest(super=" + super.toString() + ", ids=" + this.getIds() + ", names=" + this.getNames() + ", organizationIds=" + this.getOrganizationIds() + ", spaceIds=" + this.getSpaceIds() + ")";
    }

    /**
     * The ids
     *
     * @return the ids
     */
    @FilterParameter("guids")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getIds() {
        return this.ids;
    }

    /**
     * The names
     *
     * @return the names
     */
    @FilterParameter("names")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getNames() {
        return this.names;
    }

    /**
     * The organization ids
     *
     * @return the organization ids
     */
    @FilterParameter("organization_guids")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    /**
     * The space ids
     *
     * @return the space ids
     */
    @FilterParameter("space_guids")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }
}