// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Scale Application operation
 */
public final class ScaleApplicationRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * The disk size
     *
     * @param diskInMb the disk size
     */
    private final Integer diskInMb;
    
    /**
     * The number of instances
     *
     * @param instances the number of instances
     */
    private final Integer instances;
    
    /**
     * The memory size
     *
     * @param memoryInMb the memory size
     */
    private final Integer memoryInMb;
    
    /**
     * The type
     *
     * @param type the type
     */
    private final String type;

    ScaleApplicationRequest(String applicationId, Integer diskInMb, Integer instances, Integer memoryInMb, String type) {
        this.applicationId = applicationId;
        this.diskInMb = diskInMb;
        this.instances = instances;
        this.memoryInMb = memoryInMb;
        this.type = type;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.type == null) {
            builder.message("type must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ScaleApplicationRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer diskInMb;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer instances;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer memoryInMb;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String type;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ScaleApplicationRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ScaleApplicationRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ScaleApplicationRequestBuilder diskInMb(final Integer diskInMb) {
            this.diskInMb = diskInMb;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ScaleApplicationRequestBuilder instances(final Integer instances) {
            this.instances = instances;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ScaleApplicationRequestBuilder memoryInMb(final Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ScaleApplicationRequestBuilder type(final String type) {
            this.type = type;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ScaleApplicationRequest build() {
            return new ScaleApplicationRequest(applicationId, diskInMb, instances, memoryInMb, type);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ScaleApplicationRequest.ScaleApplicationRequestBuilder(applicationId=" + this.applicationId + ", diskInMb=" + this.diskInMb + ", instances=" + this.instances + ", memoryInMb=" + this.memoryInMb + ", type=" + this.type + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ScaleApplicationRequestBuilder builder() {
        return new ScaleApplicationRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ScaleApplicationRequest)) return false;
        final ScaleApplicationRequest other = (ScaleApplicationRequest)o;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$diskInMb = this.getDiskInMb();
        final java.lang.Object other$diskInMb = other.getDiskInMb();
        if (this$diskInMb == null ? other$diskInMb != null : !this$diskInMb.equals(other$diskInMb)) return false;
        final java.lang.Object this$instances = this.getInstances();
        final java.lang.Object other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !this$instances.equals(other$instances)) return false;
        final java.lang.Object this$memoryInMb = this.getMemoryInMb();
        final java.lang.Object other$memoryInMb = other.getMemoryInMb();
        if (this$memoryInMb == null ? other$memoryInMb != null : !this$memoryInMb.equals(other$memoryInMb)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $diskInMb = this.getDiskInMb();
        result = result * PRIME + ($diskInMb == null ? 43 : $diskInMb.hashCode());
        final java.lang.Object $instances = this.getInstances();
        result = result * PRIME + ($instances == null ? 43 : $instances.hashCode());
        final java.lang.Object $memoryInMb = this.getMemoryInMb();
        result = result * PRIME + ($memoryInMb == null ? 43 : $memoryInMb.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ScaleApplicationRequest(applicationId=" + this.getApplicationId() + ", diskInMb=" + this.getDiskInMb() + ", instances=" + this.getInstances() + ", memoryInMb=" + this.getMemoryInMb() + ", type=" + this.getType() + ")";
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * The disk size
     *
     * @return the disk size
     */
    @JsonProperty("disk_in_mb")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getDiskInMb() {
        return this.diskInMb;
    }

    /**
     * The number of instances
     *
     * @return the number of instances
     */
    @JsonProperty("instances")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getInstances() {
        return this.instances;
    }

    /**
     * The memory size
     *
     * @return the memory size
     */
    @JsonProperty("memory_in_mb")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    /**
     * The type
     *
     * @return the type
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getType() {
        return this.type;
    }
}