// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Delete Application Process Instance operation
 */
public final class TerminateApplicationInstanceRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * The index
     *
     * @param index the index
     */
    private final String index;
    
    /**
     * The type
     *
     * @param type the type
     */
    private final String type;

    TerminateApplicationInstanceRequest(String applicationId, String index, String type) {
        this.applicationId = applicationId;
        this.index = index;
        this.type = type;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.index == null) {
            builder.message("index must be specified");
        }
        if (this.type == null) {
            builder.message("type must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class TerminateApplicationInstanceRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String index;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String type;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        TerminateApplicationInstanceRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public TerminateApplicationInstanceRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public TerminateApplicationInstanceRequestBuilder index(final String index) {
            this.index = index;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public TerminateApplicationInstanceRequestBuilder type(final String type) {
            this.type = type;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public TerminateApplicationInstanceRequest build() {
            return new TerminateApplicationInstanceRequest(applicationId, index, type);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "TerminateApplicationInstanceRequest.TerminateApplicationInstanceRequestBuilder(applicationId=" + this.applicationId + ", index=" + this.index + ", type=" + this.type + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static TerminateApplicationInstanceRequestBuilder builder() {
        return new TerminateApplicationInstanceRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TerminateApplicationInstanceRequest)) return false;
        final TerminateApplicationInstanceRequest other = (TerminateApplicationInstanceRequest)o;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$index = this.getIndex();
        final java.lang.Object other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $index = this.getIndex();
        result = result * PRIME + ($index == null ? 43 : $index.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "TerminateApplicationInstanceRequest(applicationId=" + this.getApplicationId() + ", index=" + this.getIndex() + ", type=" + this.getType() + ")";
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * The index
     *
     * @return the index
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getIndex() {
        return this.index;
    }

    /**
     * The type
     *
     * @return the type
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getType() {
        return this.type;
    }
}