// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Delete Droplet operation
 */
public final class DeleteDropletRequest implements Validatable {
    
    /**
     * The droplet id
     *
     * @param dropletId the droplet id
     */
    private final String dropletId;

    DeleteDropletRequest(String dropletId) {
        this.dropletId = dropletId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.dropletId == null) {
            builder.message("droplet id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class DeleteDropletRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String dropletId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        DeleteDropletRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteDropletRequestBuilder dropletId(final String dropletId) {
            this.dropletId = dropletId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteDropletRequest build() {
            return new DeleteDropletRequest(dropletId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "DeleteDropletRequest.DeleteDropletRequestBuilder(dropletId=" + this.dropletId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static DeleteDropletRequestBuilder builder() {
        return new DeleteDropletRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DeleteDropletRequest)) return false;
        final DeleteDropletRequest other = (DeleteDropletRequest)o;
        final java.lang.Object this$dropletId = this.getDropletId();
        final java.lang.Object other$dropletId = other.getDropletId();
        if (this$dropletId == null ? other$dropletId != null : !this$dropletId.equals(other$dropletId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $dropletId = this.getDropletId();
        result = result * PRIME + ($dropletId == null ? 43 : $dropletId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "DeleteDropletRequest(dropletId=" + this.getDropletId() + ")";
    }

    /**
     * The droplet id
     *
     * @return the droplet id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDropletId() {
        return this.dropletId;
    }
}