// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.droplets;

import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.FilterParameter;
import org.cloudfoundry.client.v3.PaginatedAndSortedRequest;
import java.util.List;

/**
 * The request payload for the List Applications operation
 */
public final class ListDropletsRequest extends PaginatedAndSortedRequest implements Validatable {
    
    /**
     * The application ids
     *
     * @param applicationIds the application ids
     */
    private final List<String> applicationIds;
    
    /**
     * The states
     *
     * @param states the states
     */
    private final List<String> states;

    ListDropletsRequest(Integer page, Integer perPage, String orderBy, List<String> applicationIds, List<String> states) {
        super(page, perPage, orderBy);
        this.applicationIds = applicationIds;
        this.states = states;
    }

    @Override
    public ValidationResult isValid() {
        return isPaginatedAndSortedRequestValid().build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListDropletsRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer perPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String orderBy;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> applicationIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> states;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListDropletsRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDropletsRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDropletsRequestBuilder perPage(final Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDropletsRequestBuilder orderBy(final String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDropletsRequestBuilder applicationId(final String applicationId) {
            if (this.applicationIds == null) this.applicationIds = new java.util.ArrayList<String>();
            this.applicationIds.add(applicationId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDropletsRequestBuilder applicationIds(final java.util.Collection<? extends String> applicationIds) {
            if (this.applicationIds == null) this.applicationIds = new java.util.ArrayList<String>();
            this.applicationIds.addAll(applicationIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDropletsRequestBuilder state(final String state) {
            if (this.states == null) this.states = new java.util.ArrayList<String>();
            this.states.add(state);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDropletsRequestBuilder states(final java.util.Collection<? extends String> states) {
            if (this.states == null) this.states = new java.util.ArrayList<String>();
            this.states.addAll(states);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDropletsRequest build() {
            java.util.List<String> applicationIds;
            switch (this.applicationIds == null ? 0 : this.applicationIds.size()) {
            case 0: 
                applicationIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                applicationIds = java.util.Collections.singletonList(this.applicationIds.get(0));
                break;
            
            default: 
                applicationIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.applicationIds));
            
            }
            java.util.List<String> states;
            switch (this.states == null ? 0 : this.states.size()) {
            case 0: 
                states = java.util.Collections.emptyList();
                break;
            
            case 1: 
                states = java.util.Collections.singletonList(this.states.get(0));
                break;
            
            default: 
                states = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.states));
            
            }
            return new ListDropletsRequest(page, perPage, orderBy, applicationIds, states);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListDropletsRequest.ListDropletsRequestBuilder(page=" + this.page + ", perPage=" + this.perPage + ", orderBy=" + this.orderBy + ", applicationIds=" + this.applicationIds + ", states=" + this.states + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListDropletsRequestBuilder builder() {
        return new ListDropletsRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListDropletsRequest)) return false;
        final ListDropletsRequest other = (ListDropletsRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$applicationIds = this.getApplicationIds();
        final java.lang.Object other$applicationIds = other.getApplicationIds();
        if (this$applicationIds == null ? other$applicationIds != null : !this$applicationIds.equals(other$applicationIds)) return false;
        final java.lang.Object this$states = this.getStates();
        final java.lang.Object other$states = other.getStates();
        if (this$states == null ? other$states != null : !this$states.equals(other$states)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListDropletsRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $applicationIds = this.getApplicationIds();
        result = result * PRIME + ($applicationIds == null ? 43 : $applicationIds.hashCode());
        final java.lang.Object $states = this.getStates();
        result = result * PRIME + ($states == null ? 43 : $states.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListDropletsRequest(super=" + super.toString() + ", applicationIds=" + this.getApplicationIds() + ", states=" + this.getStates() + ")";
    }

    /**
     * The application ids
     *
     * @return the application ids
     */
    @FilterParameter("app_guids")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    /**
     * The states
     *
     * @return the states
     */
    @FilterParameter("states")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getStates() {
        return this.states;
    }
}