// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Copy Package operation
 */
public final class CopyPackageRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * The source package id
     *
     * @param sourcePackageId the source package id
     */
    private final String sourcePackageId;

    CopyPackageRequest(String applicationId, String sourcePackageId) {
        this.applicationId = applicationId;
        this.sourcePackageId = sourcePackageId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.sourcePackageId == null) {
            builder.message("source package id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CopyPackageRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String sourcePackageId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CopyPackageRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CopyPackageRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CopyPackageRequestBuilder sourcePackageId(final String sourcePackageId) {
            this.sourcePackageId = sourcePackageId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CopyPackageRequest build() {
            return new CopyPackageRequest(applicationId, sourcePackageId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CopyPackageRequest.CopyPackageRequestBuilder(applicationId=" + this.applicationId + ", sourcePackageId=" + this.sourcePackageId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CopyPackageRequestBuilder builder() {
        return new CopyPackageRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CopyPackageRequest)) return false;
        final CopyPackageRequest other = (CopyPackageRequest)o;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$sourcePackageId = this.getSourcePackageId();
        final java.lang.Object other$sourcePackageId = other.getSourcePackageId();
        if (this$sourcePackageId == null ? other$sourcePackageId != null : !this$sourcePackageId.equals(other$sourcePackageId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $sourcePackageId = this.getSourcePackageId();
        result = result * PRIME + ($sourcePackageId == null ? 43 : $sourcePackageId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "CopyPackageRequest(applicationId=" + this.getApplicationId() + ", sourcePackageId=" + this.getSourcePackageId() + ")";
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * The source package id
     *
     * @return the source package id
     */
    @QueryParameter("source_package_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSourcePackageId() {
        return this.sourcePackageId;
    }
}