// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import java.util.Map;

/**
 * The request payload for the Create Package operation
 */
public final class CreatePackageRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * The datas
     *
     * @param datas the datas
     */
    private final Map<String, Object> datas;
    
    /**
     * The type
     *
     * @param type the type
     */
    private final PackageType type;

    CreatePackageRequest(String applicationId, Map<String, Object> datas, PackageType type) {
        this.applicationId = applicationId;
        this.datas = datas;
        this.type = type;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.type == null) {
            builder.message("type must be specified");
        }
        return builder.build();
    }

    /**
     * The package type of the {@link CreatePackageRequest}
     */
    public enum PackageType {
        /**
         * Indicates that package type should be bits
         */
        BITS,
        /**
         * Indicates that package type should be docker
         */
        DOCKER;


        @JsonValue
        @Override
        public String toString() {
            return name().toLowerCase();
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CreatePackageRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> datas$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> datas$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private PackageType type;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CreatePackageRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreatePackageRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreatePackageRequestBuilder data(final String dataKey, final Object dataValue) {
            if (this.datas$key == null) {
                this.datas$key = new java.util.ArrayList<String>();
                this.datas$value = new java.util.ArrayList<Object>();
            }
            this.datas$key.add(dataKey);
            this.datas$value.add(dataValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreatePackageRequestBuilder datas(final java.util.Map<? extends String, ? extends Object> datas) {
            if (this.datas$key == null) {
                this.datas$key = new java.util.ArrayList<String>();
                this.datas$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : datas.entrySet()) {
                this.datas$key.add($lombokEntry.getKey());
                this.datas$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreatePackageRequestBuilder type(final PackageType type) {
            this.type = type;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreatePackageRequest build() {
            java.util.Map<String, Object> datas;
            switch (this.datas$key == null ? 0 : this.datas$key.size()) {
            case 0: 
                datas = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                datas = java.util.Collections.singletonMap(this.datas$key.get(0), this.datas$value.get(0));
                break;
            
            default: 
                datas = new java.util.LinkedHashMap<String, Object>(this.datas$key.size() < 1073741824 ? 1 + this.datas$key.size() + (this.datas$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.datas$key.size(); $i++) datas.put(this.datas$key.get($i), this.datas$value.get($i));
                datas = java.util.Collections.unmodifiableMap(datas);
            
            }
            return new CreatePackageRequest(applicationId, datas, type);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CreatePackageRequest.CreatePackageRequestBuilder(applicationId=" + this.applicationId + ", datas$key=" + this.datas$key + ", datas$value=" + this.datas$value + ", type=" + this.type + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CreatePackageRequestBuilder builder() {
        return new CreatePackageRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CreatePackageRequest)) return false;
        final CreatePackageRequest other = (CreatePackageRequest)o;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$datas = this.getDatas();
        final java.lang.Object other$datas = other.getDatas();
        if (this$datas == null ? other$datas != null : !this$datas.equals(other$datas)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $datas = this.getDatas();
        result = result * PRIME + ($datas == null ? 43 : $datas.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "CreatePackageRequest(applicationId=" + this.getApplicationId() + ", datas=" + this.getDatas() + ", type=" + this.getType() + ")";
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * The datas
     *
     * @return the datas
     */
    @JsonProperty("data")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getDatas() {
        return this.datas;
    }

    /**
     * The type
     *
     * @return the type
     */
    @JsonProperty("type")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public PackageType getType() {
        return this.type;
    }
}