// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.Lifecycle;
import java.util.Map;

/**
 * The request payload for the Stage Package operation
 */
public final class StagePackageRequest implements Validatable {
    
    /**
     * The disk limit
     *
     * @param diskLimit the disk limit
     */
    private final Integer diskLimit;
    
    /**
     * The environment variables
     *
     * @param environmentVariables the environment variables
     */
    private final Map<String, Object> environmentVariables;
    
    /**
     * The lifecycle
     *
     * @param lifecycle the lifecycle
     */
    private final Lifecycle lifecycle;
    
    /**
     * The memory limit
     *
     * @param memoryLimit the memoty limit
     */
    private final Integer memoryLimit;
    
    /**
     * The package id
     *
     * @param packageId the package id
     */
    private final String packageId;

    StagePackageRequest(Integer diskLimit, Map<String, Object> environmentVariables, Lifecycle lifecycle, Integer memoryLimit, String packageId) {
        this.diskLimit = diskLimit;
        this.environmentVariables = environmentVariables;
        this.lifecycle = lifecycle;
        this.memoryLimit = memoryLimit;
        this.packageId = packageId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.packageId == null) {
            builder.message("package id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class StagePackageRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer diskLimit;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> environmentVariables$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> environmentVariables$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Lifecycle lifecycle;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer memoryLimit;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String packageId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        StagePackageRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public StagePackageRequestBuilder diskLimit(final Integer diskLimit) {
            this.diskLimit = diskLimit;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public StagePackageRequestBuilder environmentVariable(final String environmentVariableKey, final Object environmentVariableValue) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new java.util.ArrayList<String>();
                this.environmentVariables$value = new java.util.ArrayList<Object>();
            }
            this.environmentVariables$key.add(environmentVariableKey);
            this.environmentVariables$value.add(environmentVariableValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public StagePackageRequestBuilder environmentVariables(final java.util.Map<? extends String, ? extends Object> environmentVariables) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new java.util.ArrayList<String>();
                this.environmentVariables$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : environmentVariables.entrySet()) {
                this.environmentVariables$key.add($lombokEntry.getKey());
                this.environmentVariables$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public StagePackageRequestBuilder lifecycle(final Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public StagePackageRequestBuilder memoryLimit(final Integer memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public StagePackageRequestBuilder packageId(final String packageId) {
            this.packageId = packageId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public StagePackageRequest build() {
            java.util.Map<String, Object> environmentVariables;
            switch (this.environmentVariables$key == null ? 0 : this.environmentVariables$key.size()) {
            case 0: 
                environmentVariables = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                environmentVariables = java.util.Collections.singletonMap(this.environmentVariables$key.get(0), this.environmentVariables$value.get(0));
                break;
            
            default: 
                environmentVariables = new java.util.LinkedHashMap<String, Object>(this.environmentVariables$key.size() < 1073741824 ? 1 + this.environmentVariables$key.size() + (this.environmentVariables$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.environmentVariables$key.size(); $i++) environmentVariables.put(this.environmentVariables$key.get($i), this.environmentVariables$value.get($i));
                environmentVariables = java.util.Collections.unmodifiableMap(environmentVariables);
            
            }
            return new StagePackageRequest(diskLimit, environmentVariables, lifecycle, memoryLimit, packageId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "StagePackageRequest.StagePackageRequestBuilder(diskLimit=" + this.diskLimit + ", environmentVariables$key=" + this.environmentVariables$key + ", environmentVariables$value=" + this.environmentVariables$value + ", lifecycle=" + this.lifecycle + ", memoryLimit=" + this.memoryLimit + ", packageId=" + this.packageId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static StagePackageRequestBuilder builder() {
        return new StagePackageRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof StagePackageRequest)) return false;
        final StagePackageRequest other = (StagePackageRequest)o;
        final java.lang.Object this$diskLimit = this.getDiskLimit();
        final java.lang.Object other$diskLimit = other.getDiskLimit();
        if (this$diskLimit == null ? other$diskLimit != null : !this$diskLimit.equals(other$diskLimit)) return false;
        final java.lang.Object this$environmentVariables = this.getEnvironmentVariables();
        final java.lang.Object other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !this$environmentVariables.equals(other$environmentVariables)) return false;
        final java.lang.Object this$lifecycle = this.getLifecycle();
        final java.lang.Object other$lifecycle = other.getLifecycle();
        if (this$lifecycle == null ? other$lifecycle != null : !this$lifecycle.equals(other$lifecycle)) return false;
        final java.lang.Object this$memoryLimit = this.getMemoryLimit();
        final java.lang.Object other$memoryLimit = other.getMemoryLimit();
        if (this$memoryLimit == null ? other$memoryLimit != null : !this$memoryLimit.equals(other$memoryLimit)) return false;
        final java.lang.Object this$packageId = this.getPackageId();
        final java.lang.Object other$packageId = other.getPackageId();
        if (this$packageId == null ? other$packageId != null : !this$packageId.equals(other$packageId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $diskLimit = this.getDiskLimit();
        result = result * PRIME + ($diskLimit == null ? 43 : $diskLimit.hashCode());
        final java.lang.Object $environmentVariables = this.getEnvironmentVariables();
        result = result * PRIME + ($environmentVariables == null ? 43 : $environmentVariables.hashCode());
        final java.lang.Object $lifecycle = this.getLifecycle();
        result = result * PRIME + ($lifecycle == null ? 43 : $lifecycle.hashCode());
        final java.lang.Object $memoryLimit = this.getMemoryLimit();
        result = result * PRIME + ($memoryLimit == null ? 43 : $memoryLimit.hashCode());
        final java.lang.Object $packageId = this.getPackageId();
        result = result * PRIME + ($packageId == null ? 43 : $packageId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "StagePackageRequest(diskLimit=" + this.getDiskLimit() + ", environmentVariables=" + this.getEnvironmentVariables() + ", lifecycle=" + this.getLifecycle() + ", memoryLimit=" + this.getMemoryLimit() + ", packageId=" + this.getPackageId() + ")";
    }

    /**
     * The disk limit
     *
     * @return the disk limit
     */
    @JsonProperty("disk_limit")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getDiskLimit() {
        return this.diskLimit;
    }

    /**
     * The environment variables
     *
     * @return the environment variables
     */
    @JsonProperty("environment_variables")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    /**
     * The lifecycle
     *
     * @return the lifecycle
     */
    @JsonProperty("lifecycle")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    /**
     * The memory limit
     *
     * @return the memory limit
     */
    @JsonProperty("memory_limit")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    /**
     * The package id
     *
     * @return the package id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getPackageId() {
        return this.packageId;
    }
}