// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import java.io.InputStream;

/**
 * The request payload for the Upload Package operation
 */
public final class UploadPackageRequest implements Validatable {
    
    /**
     * The bits
     *
     * @param bits the bits
     */
    private final InputStream bits;
    
    /**
     * The package id
     *
     * @param packageId the package id
     */
    private final String packageId;

    UploadPackageRequest(InputStream bits, String packageId) {
        this.bits = bits;
        this.packageId = packageId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.bits == null) {
            builder.message("bits must be specified");
        }
        if (this.packageId == null) {
            builder.message("package id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class UploadPackageRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private InputStream bits;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String packageId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        UploadPackageRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UploadPackageRequestBuilder bits(final InputStream bits) {
            this.bits = bits;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UploadPackageRequestBuilder packageId(final String packageId) {
            this.packageId = packageId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UploadPackageRequest build() {
            return new UploadPackageRequest(bits, packageId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "UploadPackageRequest.UploadPackageRequestBuilder(bits=" + this.bits + ", packageId=" + this.packageId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static UploadPackageRequestBuilder builder() {
        return new UploadPackageRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof UploadPackageRequest)) return false;
        final UploadPackageRequest other = (UploadPackageRequest)o;
        final java.lang.Object this$bits = this.getBits();
        final java.lang.Object other$bits = other.getBits();
        if (this$bits == null ? other$bits != null : !this$bits.equals(other$bits)) return false;
        final java.lang.Object this$packageId = this.getPackageId();
        final java.lang.Object other$packageId = other.getPackageId();
        if (this$packageId == null ? other$packageId != null : !this$packageId.equals(other$packageId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $bits = this.getBits();
        result = result * PRIME + ($bits == null ? 43 : $bits.hashCode());
        final java.lang.Object $packageId = this.getPackageId();
        result = result * PRIME + ($packageId == null ? 43 : $packageId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "UploadPackageRequest(bits=" + this.getBits() + ", packageId=" + this.getPackageId() + ")";
    }

    /**
     * The bits
     *
     * @return the bits
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public InputStream getBits() {
        return this.bits;
    }

    /**
     * The package id
     *
     * @return the package id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getPackageId() {
        return this.packageId;
    }
}