// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.PaginatedRequest;

/**
 * The request payload for the Get Detailed Statistics for a Process operation
 */
public final class GetProcessDetailedStatisticsRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The process id
     *
     * @param processId the process id
     */
    private final String processId;

    GetProcessDetailedStatisticsRequest(Integer page, Integer perPage, String processId) {
        super(page, perPage);
        this.processId = processId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.processId == null) {
            builder.message("process id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class GetProcessDetailedStatisticsRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer perPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String processId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        GetProcessDetailedStatisticsRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetProcessDetailedStatisticsRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetProcessDetailedStatisticsRequestBuilder perPage(final Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetProcessDetailedStatisticsRequestBuilder processId(final String processId) {
            this.processId = processId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetProcessDetailedStatisticsRequest build() {
            return new GetProcessDetailedStatisticsRequest(page, perPage, processId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "GetProcessDetailedStatisticsRequest.GetProcessDetailedStatisticsRequestBuilder(page=" + this.page + ", perPage=" + this.perPage + ", processId=" + this.processId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static GetProcessDetailedStatisticsRequestBuilder builder() {
        return new GetProcessDetailedStatisticsRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "GetProcessDetailedStatisticsRequest(processId=" + this.getProcessId() + ")";
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GetProcessDetailedStatisticsRequest)) return false;
        final GetProcessDetailedStatisticsRequest other = (GetProcessDetailedStatisticsRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$processId = this.getProcessId();
        final java.lang.Object other$processId = other.getProcessId();
        if (this$processId == null ? other$processId != null : !this$processId.equals(other$processId)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof GetProcessDetailedStatisticsRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $processId = this.getProcessId();
        result = result * PRIME + ($processId == null ? 43 : $processId.hashCode());
        return result;
    }

    /**
     * The process id
     *
     * @return the process id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getProcessId() {
        return this.processId;
    }
}