// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Singular;
import org.cloudfoundry.client.v3.Link;
import java.util.Map;

/**
 * Base class for responses that are processes
 */
public abstract class Process {
    
    /**
     * The command
     *
     * @param command the command
     */
    private final String command;
    
    /**
     * The created at
     *
     * @param createdAt the created at
     */
    private final String createdAt;
    
    /**
     * The disk in megabytes
     *
     * @param diskInMb the disk in megabytes
     */
    private final Integer diskInMb;
    
    /**
     * The id
     *
     * @param id the id
     */
    private final String id;
    
    /**
     * The instances
     *
     * @param instances the instances
     */
    private final Integer instances;
    
    /**
     * The links
     *
     * @param links the links
     */
    private final Map<String, Link> links;
    
    /**
     * The memory in megabytes
     *
     * @param memoryInMb the memory in megabytes
     */
    private final Integer memoryInMb;
    
    /**
     * The type
     *
     * @param type the type
     */
    private final String type;
    
    /**
     * The updated at
     *
     * @param updatedAt the updated at
     */
    private final String updatedAt;

    protected Process(@JsonProperty("command") String command, @JsonProperty("created_at") String createdAt, @JsonProperty("disk_in_mb") Integer diskInMb, @JsonProperty("guid") String id, @JsonProperty("instances") Integer instances, @JsonProperty("links") @Singular Map<String, Link> links, @JsonProperty("memory_in_mb") Integer memoryInMb, @JsonProperty("type") String type, @JsonProperty("updated_at") String updatedAt) {
        this.command = command;
        this.createdAt = createdAt;
        this.diskInMb = diskInMb;
        this.id = id;
        this.instances = instances;
        this.links = links;
        this.memoryInMb = memoryInMb;
        this.type = type;
        this.updatedAt = updatedAt;
    }

    /**
     * The command
     *
     * @return the command
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getCommand() {
        return this.command;
    }

    /**
     * The created at
     *
     * @return the created at
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getCreatedAt() {
        return this.createdAt;
    }

    /**
     * The disk in megabytes
     *
     * @return the disk in megabytes
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getDiskInMb() {
        return this.diskInMb;
    }

    /**
     * The id
     *
     * @return the id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getId() {
        return this.id;
    }

    /**
     * The instances
     *
     * @return the instances
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getInstances() {
        return this.instances;
    }

    /**
     * The links
     *
     * @return the links
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    /**
     * The memory in megabytes
     *
     * @return the memory in megabytes
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    /**
     * The type
     *
     * @return the type
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getType() {
        return this.type;
    }

    /**
     * The updated at
     *
     * @return the updated at
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Process)) return false;
        final Process other = (Process)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        final java.lang.Object this$command = this.getCommand();
        final java.lang.Object other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) return false;
        final java.lang.Object this$createdAt = this.getCreatedAt();
        final java.lang.Object other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) return false;
        final java.lang.Object this$diskInMb = this.getDiskInMb();
        final java.lang.Object other$diskInMb = other.getDiskInMb();
        if (this$diskInMb == null ? other$diskInMb != null : !this$diskInMb.equals(other$diskInMb)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$instances = this.getInstances();
        final java.lang.Object other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !this$instances.equals(other$instances)) return false;
        final java.lang.Object this$links = this.getLinks();
        final java.lang.Object other$links = other.getLinks();
        if (this$links == null ? other$links != null : !this$links.equals(other$links)) return false;
        final java.lang.Object this$memoryInMb = this.getMemoryInMb();
        final java.lang.Object other$memoryInMb = other.getMemoryInMb();
        if (this$memoryInMb == null ? other$memoryInMb != null : !this$memoryInMb.equals(other$memoryInMb)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        final java.lang.Object this$updatedAt = this.getUpdatedAt();
        final java.lang.Object other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Process;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $command = this.getCommand();
        result = result * PRIME + ($command == null ? 43 : $command.hashCode());
        final java.lang.Object $createdAt = this.getCreatedAt();
        result = result * PRIME + ($createdAt == null ? 43 : $createdAt.hashCode());
        final java.lang.Object $diskInMb = this.getDiskInMb();
        result = result * PRIME + ($diskInMb == null ? 43 : $diskInMb.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $instances = this.getInstances();
        result = result * PRIME + ($instances == null ? 43 : $instances.hashCode());
        final java.lang.Object $links = this.getLinks();
        result = result * PRIME + ($links == null ? 43 : $links.hashCode());
        final java.lang.Object $memoryInMb = this.getMemoryInMb();
        result = result * PRIME + ($memoryInMb == null ? 43 : $memoryInMb.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        final java.lang.Object $updatedAt = this.getUpdatedAt();
        result = result * PRIME + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "Process(command=" + this.getCommand() + ", createdAt=" + this.getCreatedAt() + ", diskInMb=" + this.getDiskInMb() + ", id=" + this.getId() + ", instances=" + this.getInstances() + ", links=" + this.getLinks() + ", memoryInMb=" + this.getMemoryInMb() + ", type=" + this.getType() + ", updatedAt=" + this.getUpdatedAt() + ")";
    }
}