// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Scale Process operation
 */
public final class ScaleProcessRequest implements Validatable {
    
    /**
     * The disk in megabytes
     *
     * @param diskInMb the disk in megabytes
     */
    private final Integer diskInMb;
    
    /**
     * The number of instances
     *
     * @param instances the number of instances
     */
    private final Integer instances;
    
    /**
     * The memory in megabytes
     *
     * @param memoryInMb the memory in megabytes
     */
    private final Integer memoryInMb;
    
    /**
     * The process id
     *
     * @param processId the process id
     */
    private final String processId;

    ScaleProcessRequest(Integer diskInMb, Integer instances, Integer memoryInMb, String processId) {
        this.diskInMb = diskInMb;
        this.instances = instances;
        this.memoryInMb = memoryInMb;
        this.processId = processId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.processId == null) {
            builder.message("process id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ScaleProcessRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer diskInMb;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer instances;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer memoryInMb;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String processId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ScaleProcessRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ScaleProcessRequestBuilder diskInMb(final Integer diskInMb) {
            this.diskInMb = diskInMb;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ScaleProcessRequestBuilder instances(final Integer instances) {
            this.instances = instances;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ScaleProcessRequestBuilder memoryInMb(final Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ScaleProcessRequestBuilder processId(final String processId) {
            this.processId = processId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ScaleProcessRequest build() {
            return new ScaleProcessRequest(diskInMb, instances, memoryInMb, processId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ScaleProcessRequest.ScaleProcessRequestBuilder(diskInMb=" + this.diskInMb + ", instances=" + this.instances + ", memoryInMb=" + this.memoryInMb + ", processId=" + this.processId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ScaleProcessRequestBuilder builder() {
        return new ScaleProcessRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ScaleProcessRequest)) return false;
        final ScaleProcessRequest other = (ScaleProcessRequest)o;
        final java.lang.Object this$diskInMb = this.getDiskInMb();
        final java.lang.Object other$diskInMb = other.getDiskInMb();
        if (this$diskInMb == null ? other$diskInMb != null : !this$diskInMb.equals(other$diskInMb)) return false;
        final java.lang.Object this$instances = this.getInstances();
        final java.lang.Object other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !this$instances.equals(other$instances)) return false;
        final java.lang.Object this$memoryInMb = this.getMemoryInMb();
        final java.lang.Object other$memoryInMb = other.getMemoryInMb();
        if (this$memoryInMb == null ? other$memoryInMb != null : !this$memoryInMb.equals(other$memoryInMb)) return false;
        final java.lang.Object this$processId = this.getProcessId();
        final java.lang.Object other$processId = other.getProcessId();
        if (this$processId == null ? other$processId != null : !this$processId.equals(other$processId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $diskInMb = this.getDiskInMb();
        result = result * PRIME + ($diskInMb == null ? 43 : $diskInMb.hashCode());
        final java.lang.Object $instances = this.getInstances();
        result = result * PRIME + ($instances == null ? 43 : $instances.hashCode());
        final java.lang.Object $memoryInMb = this.getMemoryInMb();
        result = result * PRIME + ($memoryInMb == null ? 43 : $memoryInMb.hashCode());
        final java.lang.Object $processId = this.getProcessId();
        result = result * PRIME + ($processId == null ? 43 : $processId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ScaleProcessRequest(diskInMb=" + this.getDiskInMb() + ", instances=" + this.getInstances() + ", memoryInMb=" + this.getMemoryInMb() + ", processId=" + this.getProcessId() + ")";
    }

    /**
     * The disk in megabytes
     *
     * @return the disk in megabytes
     */
    @JsonProperty("disk_in_mb")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getDiskInMb() {
        return this.diskInMb;
    }

    /**
     * The number of instances
     *
     * @return the number of instances
     */
    @JsonProperty("instances")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getInstances() {
        return this.instances;
    }

    /**
     * The memory in megabytes
     *
     * @return the memory in megabytes
     */
    @JsonProperty("memory_in_mb")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    /**
     * The process id
     *
     * @return the process id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getProcessId() {
        return this.processId;
    }
}