// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Terminate Process Instance operation
 */
public final class TerminateProcessInstanceRequest implements Validatable {
    
    /**
     * The index
     *
     * @param index the index
     */
    private final String index;
    
    /**
     * The process id
     *
     * @param processId the process id
     */
    private final String processId;

    TerminateProcessInstanceRequest(String index, String processId) {
        this.index = index;
        this.processId = processId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.index == null) {
            builder.message("index must be specified");
        }
        if (this.processId == null) {
            builder.message("process id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class TerminateProcessInstanceRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String index;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String processId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        TerminateProcessInstanceRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public TerminateProcessInstanceRequestBuilder index(final String index) {
            this.index = index;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public TerminateProcessInstanceRequestBuilder processId(final String processId) {
            this.processId = processId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public TerminateProcessInstanceRequest build() {
            return new TerminateProcessInstanceRequest(index, processId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "TerminateProcessInstanceRequest.TerminateProcessInstanceRequestBuilder(index=" + this.index + ", processId=" + this.processId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static TerminateProcessInstanceRequestBuilder builder() {
        return new TerminateProcessInstanceRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof TerminateProcessInstanceRequest)) return false;
        final TerminateProcessInstanceRequest other = (TerminateProcessInstanceRequest)o;
        final java.lang.Object this$index = this.getIndex();
        final java.lang.Object other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) return false;
        final java.lang.Object this$processId = this.getProcessId();
        final java.lang.Object other$processId = other.getProcessId();
        if (this$processId == null ? other$processId != null : !this$processId.equals(other$processId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $index = this.getIndex();
        result = result * PRIME + ($index == null ? 43 : $index.hashCode());
        final java.lang.Object $processId = this.getProcessId();
        result = result * PRIME + ($processId == null ? 43 : $processId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "TerminateProcessInstanceRequest(index=" + this.getIndex() + ", processId=" + this.getProcessId() + ")";
    }

    /**
     * The index
     *
     * @return the index
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getIndex() {
        return this.index;
    }

    /**
     * The process id
     *
     * @return the process id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getProcessId() {
        return this.processId;
    }
}