// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Update Process operation
 */
public final class UpdateProcessRequest implements Validatable {
    
    /**
     * The command
     *
     * @param command the command
     */
    private final String command;
    
    /**
     * The process id
     *
     * @param processId the process id
     */
    private final String processId;

    UpdateProcessRequest(String command, String processId) {
        this.command = command;
        this.processId = processId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.processId == null) {
            builder.message("process id must be specified");
        }
        if (this.command == null) {
            builder.message("command must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class UpdateProcessRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String command;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String processId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        UpdateProcessRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateProcessRequestBuilder command(final String command) {
            this.command = command;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateProcessRequestBuilder processId(final String processId) {
            this.processId = processId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateProcessRequest build() {
            return new UpdateProcessRequest(command, processId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "UpdateProcessRequest.UpdateProcessRequestBuilder(command=" + this.command + ", processId=" + this.processId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static UpdateProcessRequestBuilder builder() {
        return new UpdateProcessRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof UpdateProcessRequest)) return false;
        final UpdateProcessRequest other = (UpdateProcessRequest)o;
        final java.lang.Object this$command = this.getCommand();
        final java.lang.Object other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) return false;
        final java.lang.Object this$processId = this.getProcessId();
        final java.lang.Object other$processId = other.getProcessId();
        if (this$processId == null ? other$processId != null : !this$processId.equals(other$processId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $command = this.getCommand();
        result = result * PRIME + ($command == null ? 43 : $command.hashCode());
        final java.lang.Object $processId = this.getProcessId();
        result = result * PRIME + ($processId == null ? 43 : $processId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "UpdateProcessRequest(command=" + this.getCommand() + ", processId=" + this.getProcessId() + ")";
    }

    /**
     * The command
     *
     * @return the command
     */
    @JsonProperty("command")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getCommand() {
        return this.command;
    }

    /**
     * The process id
     *
     * @return the process id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getProcessId() {
        return this.processId;
    }
}