// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.tasks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import java.util.Map;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_EMPTY;

/**
 * The request payload for the Create Task endpoint
 */
public final class CreateTaskRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * The command
     *
     * @param command the command
     */
    private final String command;
    
    /**
     * The environment variables
     *
     * @param environmentVariables the environment variables
     */
    private final Map<String, String> environmentVariables;
    
    /**
     * The memoryInMb
     *
     * @param memoryInMb the memory in Mb
     */
    private final Integer memoryInMb;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;

    CreateTaskRequest(String applicationId, String command, Map<String, String> environmentVariables, String name, Integer memoryInMb) {
        this.applicationId = applicationId;
        this.command = command;
        this.environmentVariables = environmentVariables;
        this.name = name;
        this.memoryInMb = memoryInMb;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.command == null) {
            builder.message("command must be specified");
        }
        if (this.name == null) {
            builder.message("name must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CreateTaskRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String command;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> environmentVariables$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> environmentVariables$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer memoryInMb;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CreateTaskRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateTaskRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateTaskRequestBuilder command(final String command) {
            this.command = command;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateTaskRequestBuilder environmentVariable(final String environmentVariableKey, final String environmentVariableValue) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new java.util.ArrayList<String>();
                this.environmentVariables$value = new java.util.ArrayList<String>();
            }
            this.environmentVariables$key.add(environmentVariableKey);
            this.environmentVariables$value.add(environmentVariableValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateTaskRequestBuilder environmentVariables(final java.util.Map<? extends String, ? extends String> environmentVariables) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new java.util.ArrayList<String>();
                this.environmentVariables$value = new java.util.ArrayList<String>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends String> $lombokEntry : environmentVariables.entrySet()) {
                this.environmentVariables$key.add($lombokEntry.getKey());
                this.environmentVariables$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateTaskRequestBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateTaskRequestBuilder memoryInMb(final Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateTaskRequest build() {
            java.util.Map<String, String> environmentVariables;
            switch (this.environmentVariables$key == null ? 0 : this.environmentVariables$key.size()) {
            case 0: 
                environmentVariables = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                environmentVariables = java.util.Collections.singletonMap(this.environmentVariables$key.get(0), this.environmentVariables$value.get(0));
                break;
            
            default: 
                environmentVariables = new java.util.LinkedHashMap<String, String>(this.environmentVariables$key.size() < 1073741824 ? 1 + this.environmentVariables$key.size() + (this.environmentVariables$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.environmentVariables$key.size(); $i++) environmentVariables.put(this.environmentVariables$key.get($i), this.environmentVariables$value.get($i));
                environmentVariables = java.util.Collections.unmodifiableMap(environmentVariables);
            
            }
            return new CreateTaskRequest(applicationId, command, environmentVariables, name, memoryInMb);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CreateTaskRequest.CreateTaskRequestBuilder(applicationId=" + this.applicationId + ", command=" + this.command + ", environmentVariables$key=" + this.environmentVariables$key + ", environmentVariables$value=" + this.environmentVariables$value + ", name=" + this.name + ", memoryInMb=" + this.memoryInMb + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CreateTaskRequestBuilder builder() {
        return new CreateTaskRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CreateTaskRequest)) return false;
        final CreateTaskRequest other = (CreateTaskRequest)o;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$command = this.getCommand();
        final java.lang.Object other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) return false;
        final java.lang.Object this$environmentVariables = this.getEnvironmentVariables();
        final java.lang.Object other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !this$environmentVariables.equals(other$environmentVariables)) return false;
        final java.lang.Object this$memoryInMb = this.getMemoryInMb();
        final java.lang.Object other$memoryInMb = other.getMemoryInMb();
        if (this$memoryInMb == null ? other$memoryInMb != null : !this$memoryInMb.equals(other$memoryInMb)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $command = this.getCommand();
        result = result * PRIME + ($command == null ? 43 : $command.hashCode());
        final java.lang.Object $environmentVariables = this.getEnvironmentVariables();
        result = result * PRIME + ($environmentVariables == null ? 43 : $environmentVariables.hashCode());
        final java.lang.Object $memoryInMb = this.getMemoryInMb();
        result = result * PRIME + ($memoryInMb == null ? 43 : $memoryInMb.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "CreateTaskRequest(applicationId=" + this.getApplicationId() + ", command=" + this.getCommand() + ", environmentVariables=" + this.getEnvironmentVariables() + ", memoryInMb=" + this.getMemoryInMb() + ", name=" + this.getName() + ")";
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * The command
     *
     * @return the command
     */
    @JsonProperty("command")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getCommand() {
        return this.command;
    }

    /**
     * The environment variables
     *
     * @return the environment variables
     */
    @JsonInclude(NON_EMPTY)
    @JsonProperty("environment_variables")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    /**
     * The memoryInMb
     *
     * @return the memoryInMb
     */
    @JsonProperty("memory_in_mb")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    /**
     * The name
     *
     * @return the name
     */
    @JsonProperty("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }
}