// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.tasks;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.client.v3.PaginatedResponse;
import java.util.List;

/**
 * The response payload for the List Tasks operation
 */
public final class ListTasksResponse extends PaginatedResponse<TaskResource> {

    ListTasksResponse(@JsonProperty("pagination") Pagination pagination, @JsonProperty("resources") List<TaskResource> resources) {
        super(pagination, resources);
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListTasksResponseBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Pagination pagination;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<TaskResource> resources;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListTasksResponseBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListTasksResponseBuilder pagination(final Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListTasksResponseBuilder resource(final TaskResource resource) {
            if (this.resources == null) this.resources = new java.util.ArrayList<TaskResource>();
            this.resources.add(resource);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListTasksResponseBuilder resources(final java.util.Collection<? extends TaskResource> resources) {
            if (this.resources == null) this.resources = new java.util.ArrayList<TaskResource>();
            this.resources.addAll(resources);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListTasksResponse build() {
            java.util.List<TaskResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
            case 0: 
                resources = java.util.Collections.emptyList();
                break;
            
            case 1: 
                resources = java.util.Collections.singletonList(this.resources.get(0));
                break;
            
            default: 
                resources = java.util.Collections.unmodifiableList(new java.util.ArrayList<TaskResource>(this.resources));
            
            }
            return new ListTasksResponse(pagination, resources);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListTasksResponse.ListTasksResponseBuilder(pagination=" + this.pagination + ", resources=" + this.resources + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListTasksResponseBuilder builder() {
        return new ListTasksResponseBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListTasksResponse)) return false;
        final ListTasksResponse other = (ListTasksResponse)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListTasksResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListTasksResponse(super=" + super.toString() + ")";
    }
}