// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v3.tasks;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Singular;
import org.cloudfoundry.client.v3.Link;
import java.util.Map;

/**
 * Base class for responses that are tasks
 */
public abstract class Task {
    
    /**
     * The canceling state
     */
    public static final String CANCELING_STATE = "CANCELING";
    
    /**
     * The failed state
     */
    public static final String FAILED_STATE = "FAILED";
    
    /**
     * The pending state
     */
    public static final String PENDING_STATE = "PENDING";
    
    /**
     * The running state
     */
    public static final String RUNNING_STATE = "RUNNING";
    
    /**
     * The succeeded state
     */
    public static final String SUCCEEDED_STATE = "SUCCEEDED";
    
    /**
     * The command
     *
     * @param command the command
     */
    private final String command;
    
    /**
     * The created at
     *
     * @param createdAt the created at
     */
    private final String createdAt;
    
    /**
     * The environment variables
     *
     * @param environmentVariables the environment variables
     */
    private final Map<String, String> environmentVariables;
    
    /**
     * The id
     *
     * @param id the id
     */
    private final String id;
    
    /**
     * The links
     *
     * @param links the links
     */
    private final Map<String, Link> links;
    
    /**
     * The memory in megabytes
     *
     * @param memoryInMb the memory in megabytes
     */
    private final Integer memoryInMb;
    
    /**
     * The tasks name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The task result
     *
     * @param result the task result
     */
    private final Map<String, Object> results;
    
    /**
     * The tasks state, one of PENDING, RUNNING, SUCCEEDED, or FAILED
     *
     * @param state the state
     */
    private final String state;
    
    /**
     * The updated at
     *
     * @param updatedAt the updated at
     */
    private final String updatedAt;

    protected Task(@JsonProperty("command") String command, @JsonProperty("created_at") String createdAt, @JsonProperty("environment_variables") @Singular Map<String, String> environmentVariables, @JsonProperty("guid") String id, @JsonProperty("links") @Singular Map<String, Link> links, @JsonProperty("memory_in_mb") Integer memoryInMb, @JsonProperty("name") String name, @JsonProperty("result") @Singular Map<String, Object> results, @JsonProperty("state") String state, @JsonProperty("updated_at") String updatedAt) {
        this.command = command;
        this.createdAt = createdAt;
        this.environmentVariables = environmentVariables;
        this.id = id;
        this.links = links;
        this.memoryInMb = memoryInMb;
        this.name = name;
        this.results = results;
        this.state = state;
        this.updatedAt = updatedAt;
    }

    /**
     * The command
     *
     * @return the command
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getCommand() {
        return this.command;
    }

    /**
     * The created at
     *
     * @return the created at
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getCreatedAt() {
        return this.createdAt;
    }

    /**
     * The environment variables
     *
     * @return the environment variables
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    /**
     * The id
     *
     * @return the id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getId() {
        return this.id;
    }

    /**
     * The links
     *
     * @return the links
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Link> getLinks() {
        return this.links;
    }

    /**
     * The memory in megabytes
     *
     * @return the memory in megabytes
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    /**
     * The tasks name
     *
     * @return the name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The task result
     *
     * @return the task result
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getResults() {
        return this.results;
    }

    /**
     * The tasks state, one of PENDING, RUNNING, SUCCEEDED, or FAILED
     *
     * @return the state
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getState() {
        return this.state;
    }

    /**
     * The updated at
     *
     * @return the updated at
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Task)) return false;
        final Task other = (Task)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        final java.lang.Object this$command = this.getCommand();
        final java.lang.Object other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) return false;
        final java.lang.Object this$createdAt = this.getCreatedAt();
        final java.lang.Object other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) return false;
        final java.lang.Object this$environmentVariables = this.getEnvironmentVariables();
        final java.lang.Object other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !this$environmentVariables.equals(other$environmentVariables)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$links = this.getLinks();
        final java.lang.Object other$links = other.getLinks();
        if (this$links == null ? other$links != null : !this$links.equals(other$links)) return false;
        final java.lang.Object this$memoryInMb = this.getMemoryInMb();
        final java.lang.Object other$memoryInMb = other.getMemoryInMb();
        if (this$memoryInMb == null ? other$memoryInMb != null : !this$memoryInMb.equals(other$memoryInMb)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$results = this.getResults();
        final java.lang.Object other$results = other.getResults();
        if (this$results == null ? other$results != null : !this$results.equals(other$results)) return false;
        final java.lang.Object this$state = this.getState();
        final java.lang.Object other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
        final java.lang.Object this$updatedAt = this.getUpdatedAt();
        final java.lang.Object other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Task;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $command = this.getCommand();
        result = result * PRIME + ($command == null ? 43 : $command.hashCode());
        final java.lang.Object $createdAt = this.getCreatedAt();
        result = result * PRIME + ($createdAt == null ? 43 : $createdAt.hashCode());
        final java.lang.Object $environmentVariables = this.getEnvironmentVariables();
        result = result * PRIME + ($environmentVariables == null ? 43 : $environmentVariables.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $links = this.getLinks();
        result = result * PRIME + ($links == null ? 43 : $links.hashCode());
        final java.lang.Object $memoryInMb = this.getMemoryInMb();
        result = result * PRIME + ($memoryInMb == null ? 43 : $memoryInMb.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $results = this.getResults();
        result = result * PRIME + ($results == null ? 43 : $results.hashCode());
        final java.lang.Object $state = this.getState();
        result = result * PRIME + ($state == null ? 43 : $state.hashCode());
        final java.lang.Object $updatedAt = this.getUpdatedAt();
        result = result * PRIME + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "Task(command=" + this.getCommand() + ", createdAt=" + this.getCreatedAt() + ", environmentVariables=" + this.getEnvironmentVariables() + ", id=" + this.getId() + ", links=" + this.getLinks() + ", memoryInMb=" + this.getMemoryInMb() + ", name=" + this.getName() + ", results=" + this.getResults() + ", state=" + this.getState() + ", updatedAt=" + this.getUpdatedAt() + ")";
    }
}