// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.logging;

import java.util.Date;
import java.util.List;
import static java.util.concurrent.TimeUnit.NANOSECONDS;

/**
 * Base class for log messages
 */
public final class LogMessage {
    private final String applicationId;
    private final List<String> drainUrls;
    private final String message;
    private final MessageType messageType;
    private final String sourceId;
    private final String sourceName;
    private final Date timestamp;

    LogMessage(String applicationId, List<String> drainUrls, String message, MessageType messageType, String sourceId, String sourceName, Date timestamp) {
        this.applicationId = applicationId;
        this.drainUrls = drainUrls;
        this.message = message;
        this.messageType = messageType;
        this.sourceId = sourceId;
        this.sourceName = sourceName;
        this.timestamp = timestamp;
    }

    /**
     * Creates a new instance from the protobuf implementation
     *
     * @param logMessage the protobuf implementation
     * @return a new instance
     */
    public static LogMessage from(LoggregatorProtocolBuffers.LogMessage logMessage) {
        return LogMessage.builder().applicationId(logMessage.getAppId()).drainUrls(logMessage.getDrainUrlsList()).message(logMessage.getMessage().toStringUtf8()).messageType(MessageType.valueOf(logMessage.getMessageType().toString())).sourceId(logMessage.getSourceId()).sourceName(logMessage.getSourceName()).timestamp(new Date(NANOSECONDS.toMillis(logMessage.getTimestamp()))).build();
    }

    /**
     * The type of message
     */
    public enum MessageType {
        /**
         * {@code stderr} message type
         */
        ERR,
        /**
         * {@code stdout} message type
         */
        OUT;

    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class LogMessageBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> drainUrls;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String message;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private MessageType messageType;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String sourceId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String sourceName;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Date timestamp;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        LogMessageBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public LogMessageBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public LogMessageBuilder drainUrl(final String drainUrl) {
            if (this.drainUrls == null) this.drainUrls = new java.util.ArrayList<String>();
            this.drainUrls.add(drainUrl);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public LogMessageBuilder drainUrls(final java.util.Collection<? extends String> drainUrls) {
            if (this.drainUrls == null) this.drainUrls = new java.util.ArrayList<String>();
            this.drainUrls.addAll(drainUrls);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public LogMessageBuilder message(final String message) {
            this.message = message;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public LogMessageBuilder messageType(final MessageType messageType) {
            this.messageType = messageType;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public LogMessageBuilder sourceId(final String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public LogMessageBuilder sourceName(final String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public LogMessageBuilder timestamp(final Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public LogMessage build() {
            java.util.List<String> drainUrls;
            switch (this.drainUrls == null ? 0 : this.drainUrls.size()) {
            case 0: 
                drainUrls = java.util.Collections.emptyList();
                break;
            
            case 1: 
                drainUrls = java.util.Collections.singletonList(this.drainUrls.get(0));
                break;
            
            default: 
                drainUrls = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.drainUrls));
            
            }
            return new LogMessage(applicationId, drainUrls, message, messageType, sourceId, sourceName, timestamp);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "LogMessage.LogMessageBuilder(applicationId=" + this.applicationId + ", drainUrls=" + this.drainUrls + ", message=" + this.message + ", messageType=" + this.messageType + ", sourceId=" + this.sourceId + ", sourceName=" + this.sourceName + ", timestamp=" + this.timestamp + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static LogMessageBuilder builder() {
        return new LogMessageBuilder();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getDrainUrls() {
        return this.drainUrls;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getMessage() {
        return this.message;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public MessageType getMessageType() {
        return this.messageType;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSourceId() {
        return this.sourceId;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSourceName() {
        return this.sourceName;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Date getTimestamp() {
        return this.timestamp;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof LogMessage)) return false;
        final LogMessage other = (LogMessage)o;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$drainUrls = this.getDrainUrls();
        final java.lang.Object other$drainUrls = other.getDrainUrls();
        if (this$drainUrls == null ? other$drainUrls != null : !this$drainUrls.equals(other$drainUrls)) return false;
        final java.lang.Object this$message = this.getMessage();
        final java.lang.Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) return false;
        final java.lang.Object this$messageType = this.getMessageType();
        final java.lang.Object other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) return false;
        final java.lang.Object this$sourceId = this.getSourceId();
        final java.lang.Object other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) return false;
        final java.lang.Object this$sourceName = this.getSourceName();
        final java.lang.Object other$sourceName = other.getSourceName();
        if (this$sourceName == null ? other$sourceName != null : !this$sourceName.equals(other$sourceName)) return false;
        final java.lang.Object this$timestamp = this.getTimestamp();
        final java.lang.Object other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $drainUrls = this.getDrainUrls();
        result = result * PRIME + ($drainUrls == null ? 43 : $drainUrls.hashCode());
        final java.lang.Object $message = this.getMessage();
        result = result * PRIME + ($message == null ? 43 : $message.hashCode());
        final java.lang.Object $messageType = this.getMessageType();
        result = result * PRIME + ($messageType == null ? 43 : $messageType.hashCode());
        final java.lang.Object $sourceId = this.getSourceId();
        result = result * PRIME + ($sourceId == null ? 43 : $sourceId.hashCode());
        final java.lang.Object $sourceName = this.getSourceName();
        result = result * PRIME + ($sourceName == null ? 43 : $sourceName.hashCode());
        final java.lang.Object $timestamp = this.getTimestamp();
        result = result * PRIME + ($timestamp == null ? 43 : $timestamp.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "LogMessage(applicationId=" + this.getApplicationId() + ", drainUrls=" + this.getDrainUrls() + ", message=" + this.getMessage() + ", messageType=" + this.getMessageType() + ", sourceId=" + this.getSourceId() + ", sourceName=" + this.getSourceName() + ", timestamp=" + this.getTimestamp() + ")";
    }
}