// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.uaa.accesstokenadministration;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The response from the token key request
 */
public final class GetTokenKeyResponse {
    
    /**
     * The algorithm
     *
     * @param algorithm the algorithm
     */
    private final String algorithm;
    
    /**
     * The exponent
     *
     * @param e the exponent
     */
    private final String e;
    
    /**
     * The key type
     *
     * @param keyType the keyType
     */
    private final String keyType;
    
    /**
     * The modulus
     *
     * @param n the modulus
     */
    private final String n;
    
    /**
     * The use
     *
     * @param use the use
     */
    private final String use;
    
    /**
     * The value
     *
     * @param value the value
     */
    private final String value;

    GetTokenKeyResponse(@JsonProperty("alg") String algorithm, @JsonProperty("e") String e, @JsonProperty("kty") String keyType, @JsonProperty("n") String n, @JsonProperty("use") String use, @JsonProperty("value") String value) {
        this.algorithm = algorithm;
        this.e = e;
        this.keyType = keyType;
        this.n = n;
        this.use = use;
        this.value = value;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class GetTokenKeyResponseBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String algorithm;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String e;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String keyType;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String n;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String use;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String value;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        GetTokenKeyResponseBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetTokenKeyResponseBuilder algorithm(final String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetTokenKeyResponseBuilder e(final String e) {
            this.e = e;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetTokenKeyResponseBuilder keyType(final String keyType) {
            this.keyType = keyType;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetTokenKeyResponseBuilder n(final String n) {
            this.n = n;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetTokenKeyResponseBuilder use(final String use) {
            this.use = use;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetTokenKeyResponseBuilder value(final String value) {
            this.value = value;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetTokenKeyResponse build() {
            return new GetTokenKeyResponse(algorithm, e, keyType, n, use, value);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "GetTokenKeyResponse.GetTokenKeyResponseBuilder(algorithm=" + this.algorithm + ", e=" + this.e + ", keyType=" + this.keyType + ", n=" + this.n + ", use=" + this.use + ", value=" + this.value + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static GetTokenKeyResponseBuilder builder() {
        return new GetTokenKeyResponseBuilder();
    }

    /**
     * The algorithm
     *
     * @return the algorithm
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getAlgorithm() {
        return this.algorithm;
    }

    /**
     * The exponent
     *
     * @return the exponent
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getE() {
        return this.e;
    }

    /**
     * The key type
     *
     * @return the key type
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getKeyType() {
        return this.keyType;
    }

    /**
     * The modulus
     *
     * @return the modulus
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getN() {
        return this.n;
    }

    /**
     * The use
     *
     * @return the use
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getUse() {
        return this.use;
    }

    /**
     * The value
     *
     * @return the value
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getValue() {
        return this.value;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GetTokenKeyResponse)) return false;
        final GetTokenKeyResponse other = (GetTokenKeyResponse)o;
        final java.lang.Object this$algorithm = this.getAlgorithm();
        final java.lang.Object other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) return false;
        final java.lang.Object this$e = this.getE();
        final java.lang.Object other$e = other.getE();
        if (this$e == null ? other$e != null : !this$e.equals(other$e)) return false;
        final java.lang.Object this$keyType = this.getKeyType();
        final java.lang.Object other$keyType = other.getKeyType();
        if (this$keyType == null ? other$keyType != null : !this$keyType.equals(other$keyType)) return false;
        final java.lang.Object this$n = this.getN();
        final java.lang.Object other$n = other.getN();
        if (this$n == null ? other$n != null : !this$n.equals(other$n)) return false;
        final java.lang.Object this$use = this.getUse();
        final java.lang.Object other$use = other.getUse();
        if (this$use == null ? other$use != null : !this$use.equals(other$use)) return false;
        final java.lang.Object this$value = this.getValue();
        final java.lang.Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $algorithm = this.getAlgorithm();
        result = result * PRIME + ($algorithm == null ? 43 : $algorithm.hashCode());
        final java.lang.Object $e = this.getE();
        result = result * PRIME + ($e == null ? 43 : $e.hashCode());
        final java.lang.Object $keyType = this.getKeyType();
        result = result * PRIME + ($keyType == null ? 43 : $keyType.hashCode());
        final java.lang.Object $n = this.getN();
        result = result * PRIME + ($n == null ? 43 : $n.hashCode());
        final java.lang.Object $use = this.getUse();
        result = result * PRIME + ($use == null ? 43 : $use.hashCode());
        final java.lang.Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "GetTokenKeyResponse(algorithm=" + this.getAlgorithm() + ", e=" + this.getE() + ", keyType=" + this.getKeyType() + ", n=" + this.getN() + ", use=" + this.getUse() + ", value=" + this.getValue() + ")";
    }
}