// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.uaa.identityzonemanagement;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The entity response payload for Identity Zone
 */
public abstract class AbstractIdentityZone {
    
    /**
     * The creation date of the identity zone.
     *
     * @param createdAt the creation date
     */
    private final Long createdAt;
    
    /**
     * The description of the identity zone.
     *
     * @param description the description
     */
    private final String description;
    
    /**
     * The id of the identity zone.
     *
     * @param identityZoneId the identity zone id
     */
    private final String identityZoneId;
    
    /**
     * The name of the identity zone.
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The unique sub domain. It will be converted into lowercase upon creation.
     *
     * @param subdomain the sub domain
     */
    private final String subdomain;
    
    /**
     * The last modification date of the identity zone.
     *
     * @param updatedAt the last modification date
     */
    private final Long updatedAt;
    
    /**
     * The version of the identity zone.
     *
     * @param version the version
     */
    private final Integer version;

    AbstractIdentityZone(@JsonProperty("created") Long createdAt, @JsonProperty("description") String description, @JsonProperty("id") String identityZoneId, @JsonProperty("name") String name, @JsonProperty("subdomain") String subdomain, @JsonProperty("last_modified") Long updatedAt, @JsonProperty("version") Integer version) {
        this.createdAt = createdAt;
        this.description = description;
        this.identityZoneId = identityZoneId;
        this.name = name;
        this.subdomain = subdomain;
        this.updatedAt = updatedAt;
        this.version = version;
    }

    /**
     * The creation date of the identity zone.
     *
     * @return the creation date
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Long getCreatedAt() {
        return this.createdAt;
    }

    /**
     * The description of the identity zone.
     *
     * @return the description
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDescription() {
        return this.description;
    }

    /**
     * The id of the identity zone.
     *
     * @return the identity zone id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    /**
     * The name of the identity zone.
     *
     * @return the name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The unique sub domain. It will be converted into lowercase upon creation.
     *
     * @return the sub domain
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSubdomain() {
        return this.subdomain;
    }

    /**
     * The last modification date of the identity zone.
     *
     * @return the last modification date
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    /**
     * The version of the identity zone.
     *
     * @return the version
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getVersion() {
        return this.version;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AbstractIdentityZone)) return false;
        final AbstractIdentityZone other = (AbstractIdentityZone)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        final java.lang.Object this$createdAt = this.getCreatedAt();
        final java.lang.Object other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$identityZoneId = this.getIdentityZoneId();
        final java.lang.Object other$identityZoneId = other.getIdentityZoneId();
        if (this$identityZoneId == null ? other$identityZoneId != null : !this$identityZoneId.equals(other$identityZoneId)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$subdomain = this.getSubdomain();
        final java.lang.Object other$subdomain = other.getSubdomain();
        if (this$subdomain == null ? other$subdomain != null : !this$subdomain.equals(other$subdomain)) return false;
        final java.lang.Object this$updatedAt = this.getUpdatedAt();
        final java.lang.Object other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) return false;
        final java.lang.Object this$version = this.getVersion();
        final java.lang.Object other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AbstractIdentityZone;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $createdAt = this.getCreatedAt();
        result = result * PRIME + ($createdAt == null ? 43 : $createdAt.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $identityZoneId = this.getIdentityZoneId();
        result = result * PRIME + ($identityZoneId == null ? 43 : $identityZoneId.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $subdomain = this.getSubdomain();
        result = result * PRIME + ($subdomain == null ? 43 : $subdomain.hashCode());
        final java.lang.Object $updatedAt = this.getUpdatedAt();
        result = result * PRIME + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        final java.lang.Object $version = this.getVersion();
        result = result * PRIME + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "AbstractIdentityZone(createdAt=" + this.getCreatedAt() + ", description=" + this.getDescription() + ", identityZoneId=" + this.getIdentityZoneId() + ", name=" + this.getName() + ", subdomain=" + this.getSubdomain() + ", updatedAt=" + this.getUpdatedAt() + ", version=" + this.getVersion() + ")";
    }
}