// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.uaa.identityzonemanagement;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the create identity zone operation
 */
public final class CreateIdentityZoneRequest implements Validatable {
    
    /**
     * The description of the identity zone.
     *
     * @param description the description
     */
    private final String description;
    
    /**
     * The id of the identity zone. When not provided, an identifier will be generated
     *
     * @param identityZoneId the identity zone id
     */
    private final String identityZoneId;
    
    /**
     * The name of the identity zone.
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The unique subdomain. It will be converted into lowercase upon creation.
     *
     * @param subdomain the subdomain
     */
    private final String subdomain;
    
    /**
     * The version of the identity zone.
     *
     * @param version the version
     */
    private final Integer version;

    CreateIdentityZoneRequest(String description, String identityZoneId, String name, String subdomain, Integer version) {
        this.description = description;
        this.identityZoneId = identityZoneId;
        this.name = name;
        this.subdomain = subdomain;
        this.version = version;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.subdomain == null) {
            builder.message("sub domain must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CreateIdentityZoneRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String description;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String identityZoneId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String subdomain;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer version;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CreateIdentityZoneRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateIdentityZoneRequestBuilder description(final String description) {
            this.description = description;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateIdentityZoneRequestBuilder identityZoneId(final String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateIdentityZoneRequestBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateIdentityZoneRequestBuilder subdomain(final String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateIdentityZoneRequestBuilder version(final Integer version) {
            this.version = version;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateIdentityZoneRequest build() {
            return new CreateIdentityZoneRequest(description, identityZoneId, name, subdomain, version);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CreateIdentityZoneRequest.CreateIdentityZoneRequestBuilder(description=" + this.description + ", identityZoneId=" + this.identityZoneId + ", name=" + this.name + ", subdomain=" + this.subdomain + ", version=" + this.version + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CreateIdentityZoneRequestBuilder builder() {
        return new CreateIdentityZoneRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CreateIdentityZoneRequest)) return false;
        final CreateIdentityZoneRequest other = (CreateIdentityZoneRequest)o;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$identityZoneId = this.getIdentityZoneId();
        final java.lang.Object other$identityZoneId = other.getIdentityZoneId();
        if (this$identityZoneId == null ? other$identityZoneId != null : !this$identityZoneId.equals(other$identityZoneId)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$subdomain = this.getSubdomain();
        final java.lang.Object other$subdomain = other.getSubdomain();
        if (this$subdomain == null ? other$subdomain != null : !this$subdomain.equals(other$subdomain)) return false;
        final java.lang.Object this$version = this.getVersion();
        final java.lang.Object other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $identityZoneId = this.getIdentityZoneId();
        result = result * PRIME + ($identityZoneId == null ? 43 : $identityZoneId.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $subdomain = this.getSubdomain();
        result = result * PRIME + ($subdomain == null ? 43 : $subdomain.hashCode());
        final java.lang.Object $version = this.getVersion();
        result = result * PRIME + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "CreateIdentityZoneRequest(description=" + this.getDescription() + ", identityZoneId=" + this.getIdentityZoneId() + ", name=" + this.getName() + ", subdomain=" + this.getSubdomain() + ", version=" + this.getVersion() + ")";
    }

    /**
     * The description of the identity zone.
     *
     * @return the description
     */
    @JsonProperty("description")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDescription() {
        return this.description;
    }

    /**
     * The id of the identity zone. When not provided, an identifier will be generated
     *
     * @return the identity zone id
     */
    @JsonProperty("id")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    /**
     * The name of the identity zone.
     *
     * @return the name
     */
    @JsonProperty("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The unique subdomain. It will be converted into lowercase upon creation.
     *
     * @return the subdomain
     */
    @JsonProperty("subdomain")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSubdomain() {
        return this.subdomain;
    }

    /**
     * The version of the identity zone.
     *
     * @return the version
     */
    @JsonProperty("version")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getVersion() {
        return this.version;
    }
}