// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.uaa.identityzonemanagement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Delete Identity Zone operation
 */
public final class DeleteIdentityZoneRequest implements Validatable {
    
    /**
     * The identity zone id
     *
     * @param identityZoneId the identity zone id
     */
    private final String identityZoneId;

    DeleteIdentityZoneRequest(String identityZoneId) {
        this.identityZoneId = identityZoneId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.identityZoneId == null) {
            builder.message("identity zone id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class DeleteIdentityZoneRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String identityZoneId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        DeleteIdentityZoneRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteIdentityZoneRequestBuilder identityZoneId(final String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteIdentityZoneRequest build() {
            return new DeleteIdentityZoneRequest(identityZoneId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "DeleteIdentityZoneRequest.DeleteIdentityZoneRequestBuilder(identityZoneId=" + this.identityZoneId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static DeleteIdentityZoneRequestBuilder builder() {
        return new DeleteIdentityZoneRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DeleteIdentityZoneRequest)) return false;
        final DeleteIdentityZoneRequest other = (DeleteIdentityZoneRequest)o;
        final java.lang.Object this$identityZoneId = this.getIdentityZoneId();
        final java.lang.Object other$identityZoneId = other.getIdentityZoneId();
        if (this$identityZoneId == null ? other$identityZoneId != null : !this$identityZoneId.equals(other$identityZoneId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $identityZoneId = this.getIdentityZoneId();
        result = result * PRIME + ($identityZoneId == null ? 43 : $identityZoneId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "DeleteIdentityZoneRequest(identityZoneId=" + this.getIdentityZoneId() + ")";
    }

    /**
     * The identity zone id
     *
     * @return the identity zone id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }
}