/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ValidationResult {
    private final List<String> messages;
    private final Status status;

    ValidationResult(List<String> messages) {
        this.status = messages.isEmpty() ? Status.VALID : Status.INVALID;
        this.messages = messages;
    }

    public static ValidationResultBuilder builder() {
        return new ValidationResultBuilder();
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)o;
        List<String> this$messages = this.getMessages();
        List<String> other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "ValidationResult(messages=" + this.getMessages() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public static class ValidationResultBuilder {
        private ArrayList<String> messages;

        ValidationResultBuilder() {
        }

        public ValidationResultBuilder message(String message) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.add(message);
            return this;
        }

        public ValidationResultBuilder messages(Collection<? extends String> messages) {
            if (this.messages == null) {
                this.messages = new ArrayList();
            }
            this.messages.addAll(messages);
            return this;
        }

        public ValidationResult build() {
            List<String> messages;
            switch (this.messages == null ? 0 : this.messages.size()) {
                case 0: {
                    messages = Collections.emptyList();
                    break;
                }
                case 1: {
                    messages = Collections.singletonList(this.messages.get(0));
                    break;
                }
                default: {
                    messages = Collections.unmodifiableList(new ArrayList<String>(this.messages));
                }
            }
            return new ValidationResult(messages);
        }

        public String toString() {
            return "ValidationResult.ValidationResultBuilder(messages=" + this.messages + ")";
        }
    }

    public static enum Status {
        INVALID,
        VALID;

    }
}

