/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractApplicationEntity {
    private final String buildpack;
    private final String command;
    private final Boolean console;
    private final Boolean debug;
    private final String detectedStartCommand;
    private final Boolean diego;
    private final Integer diskQuota;
    private final Map<String, Object> dockerCredentialsJsons;
    private final String dockerImage;
    private final Map<String, Object> environmentJsons;
    private final Integer healthCheckTimeout;
    private final String healthCheckType;
    private final Integer instances;
    private final Integer memory;
    private final String name;
    private final Boolean production;
    private final String spaceId;
    private final String stackId;
    private final String stagingFailedDescription;
    private final String stagingFailedReason;
    private final String state;

    protected AbstractApplicationEntity(@JsonProperty(value="buildpack") String buildpack, @JsonProperty(value="command") String command, @JsonProperty(value="console") @Deprecated Boolean console, @JsonProperty(value="debug") @Deprecated Boolean debug, @JsonProperty(value="detected_start_command") String detectedStartCommand, @JsonProperty(value="diego") Boolean diego, @JsonProperty(value="disk_quota") Integer diskQuota, @JsonProperty(value="docker_credentials_json") Map<String, Object> dockerCredentialsJsons, @JsonProperty(value="docker_image") String dockerImage, @JsonProperty(value="environment_json") Map<String, Object> environmentJsons, @JsonProperty(value="health_check_timeout") Integer healthCheckTimeout, @JsonProperty(value="health_check_type") String healthCheckType, @JsonProperty(value="instances") Integer instances, @JsonProperty(value="memory") Integer memory, @JsonProperty(value="name") String name, @JsonProperty(value="production") @Deprecated Boolean production, @JsonProperty(value="space_guid") String spaceId, @JsonProperty(value="stack_guid") String stackId, @JsonProperty(value="staging_failed_description") String stagingFailedDescription, @JsonProperty(value="staging_failed_reason") String stagingFailedReason, @JsonProperty(value="state") String state) {
        this.buildpack = buildpack;
        this.command = command;
        this.console = console;
        this.debug = debug;
        this.detectedStartCommand = detectedStartCommand;
        this.diego = diego;
        this.diskQuota = diskQuota;
        this.dockerCredentialsJsons = Optional.ofNullable(dockerCredentialsJsons).orElse(Collections.emptyMap());
        this.dockerImage = dockerImage;
        this.environmentJsons = Optional.ofNullable(environmentJsons).orElse(Collections.emptyMap());
        this.healthCheckTimeout = healthCheckTimeout;
        this.healthCheckType = healthCheckType;
        this.instances = instances;
        this.memory = memory;
        this.name = name;
        this.production = production;
        this.spaceId = spaceId;
        this.stackId = stackId;
        this.stagingFailedDescription = stagingFailedDescription;
        this.stagingFailedReason = stagingFailedReason;
        this.state = state;
    }

    public String getBuildpack() {
        return this.buildpack;
    }

    public String getCommand() {
        return this.command;
    }

    public String getDetectedStartCommand() {
        return this.detectedStartCommand;
    }

    public Boolean getDiego() {
        return this.diego;
    }

    public Integer getDiskQuota() {
        return this.diskQuota;
    }

    public Map<String, Object> getDockerCredentialsJsons() {
        return this.dockerCredentialsJsons;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    public Map<String, Object> getEnvironmentJsons() {
        return this.environmentJsons;
    }

    public Integer getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    public Integer getInstances() {
        return this.instances;
    }

    public Integer getMemory() {
        return this.memory;
    }

    public String getName() {
        return this.name;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public String getStackId() {
        return this.stackId;
    }

    public String getStagingFailedDescription() {
        return this.stagingFailedDescription;
    }

    public String getStagingFailedReason() {
        return this.stagingFailedReason;
    }

    public String getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractApplicationEntity)) {
            return false;
        }
        AbstractApplicationEntity other = (AbstractApplicationEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$buildpack = this.getBuildpack();
        String other$buildpack = other.getBuildpack();
        if (this$buildpack == null ? other$buildpack != null : !this$buildpack.equals(other$buildpack)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        Boolean this$console = this.getConsole();
        Boolean other$console = other.getConsole();
        if (this$console == null ? other$console != null : !((Object)this$console).equals(other$console)) {
            return false;
        }
        Boolean this$debug = this.getDebug();
        Boolean other$debug = other.getDebug();
        if (this$debug == null ? other$debug != null : !((Object)this$debug).equals(other$debug)) {
            return false;
        }
        String this$detectedStartCommand = this.getDetectedStartCommand();
        String other$detectedStartCommand = other.getDetectedStartCommand();
        if (this$detectedStartCommand == null ? other$detectedStartCommand != null : !this$detectedStartCommand.equals(other$detectedStartCommand)) {
            return false;
        }
        Boolean this$diego = this.getDiego();
        Boolean other$diego = other.getDiego();
        if (this$diego == null ? other$diego != null : !((Object)this$diego).equals(other$diego)) {
            return false;
        }
        Integer this$diskQuota = this.getDiskQuota();
        Integer other$diskQuota = other.getDiskQuota();
        if (this$diskQuota == null ? other$diskQuota != null : !((Object)this$diskQuota).equals(other$diskQuota)) {
            return false;
        }
        Map<String, Object> this$dockerCredentialsJsons = this.getDockerCredentialsJsons();
        Map<String, Object> other$dockerCredentialsJsons = other.getDockerCredentialsJsons();
        if (this$dockerCredentialsJsons == null ? other$dockerCredentialsJsons != null : !((Object)this$dockerCredentialsJsons).equals(other$dockerCredentialsJsons)) {
            return false;
        }
        String this$dockerImage = this.getDockerImage();
        String other$dockerImage = other.getDockerImage();
        if (this$dockerImage == null ? other$dockerImage != null : !this$dockerImage.equals(other$dockerImage)) {
            return false;
        }
        Map<String, Object> this$environmentJsons = this.getEnvironmentJsons();
        Map<String, Object> other$environmentJsons = other.getEnvironmentJsons();
        if (this$environmentJsons == null ? other$environmentJsons != null : !((Object)this$environmentJsons).equals(other$environmentJsons)) {
            return false;
        }
        Integer this$healthCheckTimeout = this.getHealthCheckTimeout();
        Integer other$healthCheckTimeout = other.getHealthCheckTimeout();
        if (this$healthCheckTimeout == null ? other$healthCheckTimeout != null : !((Object)this$healthCheckTimeout).equals(other$healthCheckTimeout)) {
            return false;
        }
        String this$healthCheckType = this.getHealthCheckType();
        String other$healthCheckType = other.getHealthCheckType();
        if (this$healthCheckType == null ? other$healthCheckType != null : !this$healthCheckType.equals(other$healthCheckType)) {
            return false;
        }
        Integer this$instances = this.getInstances();
        Integer other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances)) {
            return false;
        }
        Integer this$memory = this.getMemory();
        Integer other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Boolean this$production = this.getProduction();
        Boolean other$production = other.getProduction();
        if (this$production == null ? other$production != null : !((Object)this$production).equals(other$production)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) {
            return false;
        }
        String this$stackId = this.getStackId();
        String other$stackId = other.getStackId();
        if (this$stackId == null ? other$stackId != null : !this$stackId.equals(other$stackId)) {
            return false;
        }
        String this$stagingFailedDescription = this.getStagingFailedDescription();
        String other$stagingFailedDescription = other.getStagingFailedDescription();
        if (this$stagingFailedDescription == null ? other$stagingFailedDescription != null : !this$stagingFailedDescription.equals(other$stagingFailedDescription)) {
            return false;
        }
        String this$stagingFailedReason = this.getStagingFailedReason();
        String other$stagingFailedReason = other.getStagingFailedReason();
        if (this$stagingFailedReason == null ? other$stagingFailedReason != null : !this$stagingFailedReason.equals(other$stagingFailedReason)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        return !(this$state == null ? other$state != null : !this$state.equals(other$state));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractApplicationEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $buildpack = this.getBuildpack();
        result = result * 59 + ($buildpack == null ? 43 : $buildpack.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        Boolean $console = this.getConsole();
        result = result * 59 + ($console == null ? 43 : ((Object)$console).hashCode());
        Boolean $debug = this.getDebug();
        result = result * 59 + ($debug == null ? 43 : ((Object)$debug).hashCode());
        String $detectedStartCommand = this.getDetectedStartCommand();
        result = result * 59 + ($detectedStartCommand == null ? 43 : $detectedStartCommand.hashCode());
        Boolean $diego = this.getDiego();
        result = result * 59 + ($diego == null ? 43 : ((Object)$diego).hashCode());
        Integer $diskQuota = this.getDiskQuota();
        result = result * 59 + ($diskQuota == null ? 43 : ((Object)$diskQuota).hashCode());
        Map<String, Object> $dockerCredentialsJsons = this.getDockerCredentialsJsons();
        result = result * 59 + ($dockerCredentialsJsons == null ? 43 : ((Object)$dockerCredentialsJsons).hashCode());
        String $dockerImage = this.getDockerImage();
        result = result * 59 + ($dockerImage == null ? 43 : $dockerImage.hashCode());
        Map<String, Object> $environmentJsons = this.getEnvironmentJsons();
        result = result * 59 + ($environmentJsons == null ? 43 : ((Object)$environmentJsons).hashCode());
        Integer $healthCheckTimeout = this.getHealthCheckTimeout();
        result = result * 59 + ($healthCheckTimeout == null ? 43 : ((Object)$healthCheckTimeout).hashCode());
        String $healthCheckType = this.getHealthCheckType();
        result = result * 59 + ($healthCheckType == null ? 43 : $healthCheckType.hashCode());
        Integer $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        Integer $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Boolean $production = this.getProduction();
        result = result * 59 + ($production == null ? 43 : ((Object)$production).hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        String $stackId = this.getStackId();
        result = result * 59 + ($stackId == null ? 43 : $stackId.hashCode());
        String $stagingFailedDescription = this.getStagingFailedDescription();
        result = result * 59 + ($stagingFailedDescription == null ? 43 : $stagingFailedDescription.hashCode());
        String $stagingFailedReason = this.getStagingFailedReason();
        result = result * 59 + ($stagingFailedReason == null ? 43 : $stagingFailedReason.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractApplicationEntity(buildpack=" + this.getBuildpack() + ", command=" + this.getCommand() + ", console=" + this.getConsole() + ", debug=" + this.getDebug() + ", detectedStartCommand=" + this.getDetectedStartCommand() + ", diego=" + this.getDiego() + ", diskQuota=" + this.getDiskQuota() + ", dockerCredentialsJsons=" + this.getDockerCredentialsJsons() + ", dockerImage=" + this.getDockerImage() + ", environmentJsons=" + this.getEnvironmentJsons() + ", healthCheckTimeout=" + this.getHealthCheckTimeout() + ", healthCheckType=" + this.getHealthCheckType() + ", instances=" + this.getInstances() + ", memory=" + this.getMemory() + ", name=" + this.getName() + ", production=" + this.getProduction() + ", spaceId=" + this.getSpaceId() + ", stackId=" + this.getStackId() + ", stagingFailedDescription=" + this.getStagingFailedDescription() + ", stagingFailedReason=" + this.getStagingFailedReason() + ", state=" + this.getState() + ")";
    }

    @Deprecated
    public Boolean getConsole() {
        return this.console;
    }

    @Deprecated
    public Boolean getDebug() {
        return this.debug;
    }

    @Deprecated
    public Boolean getProduction() {
        return this.production;
    }
}

