/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.cloudfoundry.client.v2.applications.AbstractApplicationEntity;

public final class ApplicationEntity
extends AbstractApplicationEntity {
    private final String detectedBuildpack;
    private final Boolean enableSsh;
    private final String eventsUrl;
    private final String packageState;
    private final String packageUpdatedAt;
    private final List<Integer> ports;
    private final String routeMappingsUrl;
    private final String routesUrl;
    private final String serviceBindingsUrl;
    private final String spaceUrl;
    private final String stackUrl;
    private final String stagingTaskId;
    private final String version;

    ApplicationEntity(@JsonProperty(value="buildpack") String buildpack, @JsonProperty(value="command") String command, @JsonProperty(value="console") @Deprecated Boolean console, @JsonProperty(value="debug") @Deprecated Boolean debug, @JsonProperty(value="detected_buildpack") String detectedBuildpack, @JsonProperty(value="detected_start_command") String detectedStartCommand, @JsonProperty(value="diego") Boolean diego, @JsonProperty(value="disk_quota") Integer diskQuota, @JsonProperty(value="docker_credentials_json") Map<String, Object> dockerCredentialsJsons, @JsonProperty(value="docker_image") String dockerImage, @JsonProperty(value="enable_ssh") Boolean enableSsh, @JsonProperty(value="environment_json") Map<String, Object> environmentJsons, @JsonProperty(value="events_url") String eventsUrl, @JsonProperty(value="health_check_timeout") Integer healthCheckTimeout, @JsonProperty(value="health_check_type") String healthCheckType, @JsonProperty(value="instances") Integer instances, @JsonProperty(value="memory") Integer memory, @JsonProperty(value="name") String name, @JsonProperty(value="package_state") String packageState, @JsonProperty(value="package_updated_at") String packageUpdatedAt, @JsonProperty(value="production") @Deprecated Boolean production, @JsonProperty(value="route_mappings_url") String routeMappingsUrl, @JsonProperty(value="routes_url") String routesUrl, @JsonProperty(value="service_bindings_url") String serviceBindingsUrl, @JsonProperty(value="space_guid") String spaceId, @JsonProperty(value="space_url") String spaceUrl, @JsonProperty(value="stack_guid") String stackId, @JsonProperty(value="stack_url") String stackUrl, @JsonProperty(value="staging_failed_description") String stagingFailedDescription, @JsonProperty(value="staging_failed_reason") String stagingFailedReason, @JsonProperty(value="ports") List<Integer> ports, @JsonProperty(value="staging_task_id") String stagingTaskId, @JsonProperty(value="state") String state, @JsonProperty(value="version") String version) {
        super(buildpack, command, console, debug, detectedStartCommand, diego, diskQuota, dockerCredentialsJsons, dockerImage, environmentJsons, healthCheckTimeout, healthCheckType, instances, memory, name, production, spaceId, stackId, stagingFailedDescription, stagingFailedReason, state);
        this.detectedBuildpack = detectedBuildpack;
        this.enableSsh = enableSsh;
        this.eventsUrl = eventsUrl;
        this.packageState = packageState;
        this.packageUpdatedAt = packageUpdatedAt;
        this.routeMappingsUrl = routeMappingsUrl;
        this.routesUrl = routesUrl;
        this.serviceBindingsUrl = serviceBindingsUrl;
        this.spaceUrl = spaceUrl;
        this.stackUrl = stackUrl;
        this.ports = Optional.ofNullable(ports).orElse(Collections.emptyList());
        this.stagingTaskId = stagingTaskId;
        this.version = version;
    }

    public static ApplicationEntityBuilder builder() {
        return new ApplicationEntityBuilder();
    }

    public String getDetectedBuildpack() {
        return this.detectedBuildpack;
    }

    public Boolean getEnableSsh() {
        return this.enableSsh;
    }

    public String getEventsUrl() {
        return this.eventsUrl;
    }

    public String getPackageState() {
        return this.packageState;
    }

    public String getPackageUpdatedAt() {
        return this.packageUpdatedAt;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public String getRouteMappingsUrl() {
        return this.routeMappingsUrl;
    }

    public String getRoutesUrl() {
        return this.routesUrl;
    }

    public String getServiceBindingsUrl() {
        return this.serviceBindingsUrl;
    }

    public String getSpaceUrl() {
        return this.spaceUrl;
    }

    public String getStackUrl() {
        return this.stackUrl;
    }

    public String getStagingTaskId() {
        return this.stagingTaskId;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationEntity)) {
            return false;
        }
        ApplicationEntity other = (ApplicationEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$detectedBuildpack = this.getDetectedBuildpack();
        String other$detectedBuildpack = other.getDetectedBuildpack();
        if (this$detectedBuildpack == null ? other$detectedBuildpack != null : !this$detectedBuildpack.equals(other$detectedBuildpack)) {
            return false;
        }
        Boolean this$enableSsh = this.getEnableSsh();
        Boolean other$enableSsh = other.getEnableSsh();
        if (this$enableSsh == null ? other$enableSsh != null : !((Object)this$enableSsh).equals(other$enableSsh)) {
            return false;
        }
        String this$eventsUrl = this.getEventsUrl();
        String other$eventsUrl = other.getEventsUrl();
        if (this$eventsUrl == null ? other$eventsUrl != null : !this$eventsUrl.equals(other$eventsUrl)) {
            return false;
        }
        String this$packageState = this.getPackageState();
        String other$packageState = other.getPackageState();
        if (this$packageState == null ? other$packageState != null : !this$packageState.equals(other$packageState)) {
            return false;
        }
        String this$packageUpdatedAt = this.getPackageUpdatedAt();
        String other$packageUpdatedAt = other.getPackageUpdatedAt();
        if (this$packageUpdatedAt == null ? other$packageUpdatedAt != null : !this$packageUpdatedAt.equals(other$packageUpdatedAt)) {
            return false;
        }
        List<Integer> this$ports = this.getPorts();
        List<Integer> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        String this$routeMappingsUrl = this.getRouteMappingsUrl();
        String other$routeMappingsUrl = other.getRouteMappingsUrl();
        if (this$routeMappingsUrl == null ? other$routeMappingsUrl != null : !this$routeMappingsUrl.equals(other$routeMappingsUrl)) {
            return false;
        }
        String this$routesUrl = this.getRoutesUrl();
        String other$routesUrl = other.getRoutesUrl();
        if (this$routesUrl == null ? other$routesUrl != null : !this$routesUrl.equals(other$routesUrl)) {
            return false;
        }
        String this$serviceBindingsUrl = this.getServiceBindingsUrl();
        String other$serviceBindingsUrl = other.getServiceBindingsUrl();
        if (this$serviceBindingsUrl == null ? other$serviceBindingsUrl != null : !this$serviceBindingsUrl.equals(other$serviceBindingsUrl)) {
            return false;
        }
        String this$spaceUrl = this.getSpaceUrl();
        String other$spaceUrl = other.getSpaceUrl();
        if (this$spaceUrl == null ? other$spaceUrl != null : !this$spaceUrl.equals(other$spaceUrl)) {
            return false;
        }
        String this$stackUrl = this.getStackUrl();
        String other$stackUrl = other.getStackUrl();
        if (this$stackUrl == null ? other$stackUrl != null : !this$stackUrl.equals(other$stackUrl)) {
            return false;
        }
        String this$stagingTaskId = this.getStagingTaskId();
        String other$stagingTaskId = other.getStagingTaskId();
        if (this$stagingTaskId == null ? other$stagingTaskId != null : !this$stagingTaskId.equals(other$stagingTaskId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ApplicationEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $detectedBuildpack = this.getDetectedBuildpack();
        result = result * 59 + ($detectedBuildpack == null ? 43 : $detectedBuildpack.hashCode());
        Boolean $enableSsh = this.getEnableSsh();
        result = result * 59 + ($enableSsh == null ? 43 : ((Object)$enableSsh).hashCode());
        String $eventsUrl = this.getEventsUrl();
        result = result * 59 + ($eventsUrl == null ? 43 : $eventsUrl.hashCode());
        String $packageState = this.getPackageState();
        result = result * 59 + ($packageState == null ? 43 : $packageState.hashCode());
        String $packageUpdatedAt = this.getPackageUpdatedAt();
        result = result * 59 + ($packageUpdatedAt == null ? 43 : $packageUpdatedAt.hashCode());
        List<Integer> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        String $routeMappingsUrl = this.getRouteMappingsUrl();
        result = result * 59 + ($routeMappingsUrl == null ? 43 : $routeMappingsUrl.hashCode());
        String $routesUrl = this.getRoutesUrl();
        result = result * 59 + ($routesUrl == null ? 43 : $routesUrl.hashCode());
        String $serviceBindingsUrl = this.getServiceBindingsUrl();
        result = result * 59 + ($serviceBindingsUrl == null ? 43 : $serviceBindingsUrl.hashCode());
        String $spaceUrl = this.getSpaceUrl();
        result = result * 59 + ($spaceUrl == null ? 43 : $spaceUrl.hashCode());
        String $stackUrl = this.getStackUrl();
        result = result * 59 + ($stackUrl == null ? 43 : $stackUrl.hashCode());
        String $stagingTaskId = this.getStagingTaskId();
        result = result * 59 + ($stagingTaskId == null ? 43 : $stagingTaskId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ApplicationEntity(super=" + super.toString() + ", detectedBuildpack=" + this.getDetectedBuildpack() + ", enableSsh=" + this.getEnableSsh() + ", eventsUrl=" + this.getEventsUrl() + ", packageState=" + this.getPackageState() + ", packageUpdatedAt=" + this.getPackageUpdatedAt() + ", ports=" + this.getPorts() + ", routeMappingsUrl=" + this.getRouteMappingsUrl() + ", routesUrl=" + this.getRoutesUrl() + ", serviceBindingsUrl=" + this.getServiceBindingsUrl() + ", spaceUrl=" + this.getSpaceUrl() + ", stackUrl=" + this.getStackUrl() + ", stagingTaskId=" + this.getStagingTaskId() + ", version=" + this.getVersion() + ")";
    }

    public static class ApplicationEntityBuilder {
        private String buildpack;
        private String command;
        private Boolean console;
        private Boolean debug;
        private String detectedBuildpack;
        private String detectedStartCommand;
        private Boolean diego;
        private Integer diskQuota;
        private ArrayList<String> dockerCredentialsJsons$key;
        private ArrayList<Object> dockerCredentialsJsons$value;
        private String dockerImage;
        private Boolean enableSsh;
        private ArrayList<String> environmentJsons$key;
        private ArrayList<Object> environmentJsons$value;
        private String eventsUrl;
        private Integer healthCheckTimeout;
        private String healthCheckType;
        private Integer instances;
        private Integer memory;
        private String name;
        private String packageState;
        private String packageUpdatedAt;
        private Boolean production;
        private String routeMappingsUrl;
        private String routesUrl;
        private String serviceBindingsUrl;
        private String spaceId;
        private String spaceUrl;
        private String stackId;
        private String stackUrl;
        private String stagingFailedDescription;
        private String stagingFailedReason;
        private ArrayList<Integer> ports;
        private String stagingTaskId;
        private String state;
        private String version;

        ApplicationEntityBuilder() {
        }

        public ApplicationEntityBuilder buildpack(String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        public ApplicationEntityBuilder command(String command) {
            this.command = command;
            return this;
        }

        public ApplicationEntityBuilder console(Boolean console) {
            this.console = console;
            return this;
        }

        public ApplicationEntityBuilder debug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public ApplicationEntityBuilder detectedBuildpack(String detectedBuildpack) {
            this.detectedBuildpack = detectedBuildpack;
            return this;
        }

        public ApplicationEntityBuilder detectedStartCommand(String detectedStartCommand) {
            this.detectedStartCommand = detectedStartCommand;
            return this;
        }

        public ApplicationEntityBuilder diego(Boolean diego) {
            this.diego = diego;
            return this;
        }

        public ApplicationEntityBuilder diskQuota(Integer diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        public ApplicationEntityBuilder dockerCredentialsJson(String dockerCredentialsJsonKey, Object dockerCredentialsJsonValue) {
            if (this.dockerCredentialsJsons$key == null) {
                this.dockerCredentialsJsons$key = new ArrayList();
                this.dockerCredentialsJsons$value = new ArrayList();
            }
            this.dockerCredentialsJsons$key.add(dockerCredentialsJsonKey);
            this.dockerCredentialsJsons$value.add(dockerCredentialsJsonValue);
            return this;
        }

        public ApplicationEntityBuilder dockerCredentialsJsons(Map<? extends String, ? extends Object> dockerCredentialsJsons) {
            if (this.dockerCredentialsJsons$key == null) {
                this.dockerCredentialsJsons$key = new ArrayList();
                this.dockerCredentialsJsons$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : dockerCredentialsJsons.entrySet()) {
                this.dockerCredentialsJsons$key.add($lombokEntry.getKey());
                this.dockerCredentialsJsons$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ApplicationEntityBuilder dockerImage(String dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        public ApplicationEntityBuilder enableSsh(Boolean enableSsh) {
            this.enableSsh = enableSsh;
            return this;
        }

        public ApplicationEntityBuilder environmentJson(String environmentJsonKey, Object environmentJsonValue) {
            if (this.environmentJsons$key == null) {
                this.environmentJsons$key = new ArrayList();
                this.environmentJsons$value = new ArrayList();
            }
            this.environmentJsons$key.add(environmentJsonKey);
            this.environmentJsons$value.add(environmentJsonValue);
            return this;
        }

        public ApplicationEntityBuilder environmentJsons(Map<? extends String, ? extends Object> environmentJsons) {
            if (this.environmentJsons$key == null) {
                this.environmentJsons$key = new ArrayList();
                this.environmentJsons$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : environmentJsons.entrySet()) {
                this.environmentJsons$key.add($lombokEntry.getKey());
                this.environmentJsons$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ApplicationEntityBuilder eventsUrl(String eventsUrl) {
            this.eventsUrl = eventsUrl;
            return this;
        }

        public ApplicationEntityBuilder healthCheckTimeout(Integer healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
            return this;
        }

        public ApplicationEntityBuilder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public ApplicationEntityBuilder instances(Integer instances) {
            this.instances = instances;
            return this;
        }

        public ApplicationEntityBuilder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public ApplicationEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ApplicationEntityBuilder packageState(String packageState) {
            this.packageState = packageState;
            return this;
        }

        public ApplicationEntityBuilder packageUpdatedAt(String packageUpdatedAt) {
            this.packageUpdatedAt = packageUpdatedAt;
            return this;
        }

        public ApplicationEntityBuilder production(Boolean production) {
            this.production = production;
            return this;
        }

        public ApplicationEntityBuilder routeMappingsUrl(String routeMappingsUrl) {
            this.routeMappingsUrl = routeMappingsUrl;
            return this;
        }

        public ApplicationEntityBuilder routesUrl(String routesUrl) {
            this.routesUrl = routesUrl;
            return this;
        }

        public ApplicationEntityBuilder serviceBindingsUrl(String serviceBindingsUrl) {
            this.serviceBindingsUrl = serviceBindingsUrl;
            return this;
        }

        public ApplicationEntityBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public ApplicationEntityBuilder spaceUrl(String spaceUrl) {
            this.spaceUrl = spaceUrl;
            return this;
        }

        public ApplicationEntityBuilder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public ApplicationEntityBuilder stackUrl(String stackUrl) {
            this.stackUrl = stackUrl;
            return this;
        }

        public ApplicationEntityBuilder stagingFailedDescription(String stagingFailedDescription) {
            this.stagingFailedDescription = stagingFailedDescription;
            return this;
        }

        public ApplicationEntityBuilder stagingFailedReason(String stagingFailedReason) {
            this.stagingFailedReason = stagingFailedReason;
            return this;
        }

        public ApplicationEntityBuilder port(Integer port) {
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.add(port);
            return this;
        }

        public ApplicationEntityBuilder ports(Collection<? extends Integer> ports) {
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.addAll(ports);
            return this;
        }

        public ApplicationEntityBuilder stagingTaskId(String stagingTaskId) {
            this.stagingTaskId = stagingTaskId;
            return this;
        }

        public ApplicationEntityBuilder state(String state) {
            this.state = state;
            return this;
        }

        public ApplicationEntityBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ApplicationEntity build() {
            List<Integer> ports;
            Map<Object, Object> environmentJsons;
            Map<Object, Object> dockerCredentialsJsons;
            switch (this.dockerCredentialsJsons$key == null ? 0 : this.dockerCredentialsJsons$key.size()) {
                case 0: {
                    dockerCredentialsJsons = Collections.emptyMap();
                    break;
                }
                case 1: {
                    dockerCredentialsJsons = Collections.singletonMap(this.dockerCredentialsJsons$key.get(0), this.dockerCredentialsJsons$value.get(0));
                    break;
                }
                default: {
                    dockerCredentialsJsons = new LinkedHashMap(this.dockerCredentialsJsons$key.size() < 0x40000000 ? 1 + this.dockerCredentialsJsons$key.size() + (this.dockerCredentialsJsons$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.dockerCredentialsJsons$key.size(); ++$i) {
                        dockerCredentialsJsons.put(this.dockerCredentialsJsons$key.get($i), this.dockerCredentialsJsons$value.get($i));
                    }
                    dockerCredentialsJsons = Collections.unmodifiableMap(dockerCredentialsJsons);
                }
            }
            switch (this.environmentJsons$key == null ? 0 : this.environmentJsons$key.size()) {
                case 0: {
                    environmentJsons = Collections.emptyMap();
                    break;
                }
                case 1: {
                    environmentJsons = Collections.singletonMap(this.environmentJsons$key.get(0), this.environmentJsons$value.get(0));
                    break;
                }
                default: {
                    environmentJsons = new LinkedHashMap(this.environmentJsons$key.size() < 0x40000000 ? 1 + this.environmentJsons$key.size() + (this.environmentJsons$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.environmentJsons$key.size(); ++$i) {
                        environmentJsons.put(this.environmentJsons$key.get($i), this.environmentJsons$value.get($i));
                    }
                    environmentJsons = Collections.unmodifiableMap(environmentJsons);
                }
            }
            switch (this.ports == null ? 0 : this.ports.size()) {
                case 0: {
                    ports = Collections.emptyList();
                    break;
                }
                case 1: {
                    ports = Collections.singletonList(this.ports.get(0));
                    break;
                }
                default: {
                    ports = Collections.unmodifiableList(new ArrayList<Integer>(this.ports));
                }
            }
            return new ApplicationEntity(this.buildpack, this.command, this.console, this.debug, this.detectedBuildpack, this.detectedStartCommand, this.diego, this.diskQuota, dockerCredentialsJsons, this.dockerImage, this.enableSsh, environmentJsons, this.eventsUrl, this.healthCheckTimeout, this.healthCheckType, this.instances, this.memory, this.name, this.packageState, this.packageUpdatedAt, this.production, this.routeMappingsUrl, this.routesUrl, this.serviceBindingsUrl, this.spaceId, this.spaceUrl, this.stackId, this.stackUrl, this.stagingFailedDescription, this.stagingFailedReason, ports, this.stagingTaskId, this.state, this.version);
        }

        public String toString() {
            return "ApplicationEntity.ApplicationEntityBuilder(buildpack=" + this.buildpack + ", command=" + this.command + ", console=" + this.console + ", debug=" + this.debug + ", detectedBuildpack=" + this.detectedBuildpack + ", detectedStartCommand=" + this.detectedStartCommand + ", diego=" + this.diego + ", diskQuota=" + this.diskQuota + ", dockerCredentialsJsons$key=" + this.dockerCredentialsJsons$key + ", dockerCredentialsJsons$value=" + this.dockerCredentialsJsons$value + ", dockerImage=" + this.dockerImage + ", enableSsh=" + this.enableSsh + ", environmentJsons$key=" + this.environmentJsons$key + ", environmentJsons$value=" + this.environmentJsons$value + ", eventsUrl=" + this.eventsUrl + ", healthCheckTimeout=" + this.healthCheckTimeout + ", healthCheckType=" + this.healthCheckType + ", instances=" + this.instances + ", memory=" + this.memory + ", name=" + this.name + ", packageState=" + this.packageState + ", packageUpdatedAt=" + this.packageUpdatedAt + ", production=" + this.production + ", routeMappingsUrl=" + this.routeMappingsUrl + ", routesUrl=" + this.routesUrl + ", serviceBindingsUrl=" + this.serviceBindingsUrl + ", spaceId=" + this.spaceId + ", spaceUrl=" + this.spaceUrl + ", stackId=" + this.stackId + ", stackUrl=" + this.stackUrl + ", stagingFailedDescription=" + this.stagingFailedDescription + ", stagingFailedReason=" + this.stagingFailedReason + ", ports=" + this.ports + ", stagingTaskId=" + this.stagingTaskId + ", state=" + this.state + ", version=" + this.version + ")";
        }
    }
}

