/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.client.v2.applications.ApplicationInstanceInfo;

public final class ApplicationInstancesResponse
extends HashMap<String, ApplicationInstanceInfo> {
    private static final long serialVersionUID = 7561486569934101780L;

    ApplicationInstancesResponse() {
    }

    ApplicationInstancesResponse(Map<String, ApplicationInstanceInfo> instances) {
        super(instances);
    }

    public static ApplicationInstancesResponseBuilder builder() {
        return new ApplicationInstancesResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationInstancesResponse)) {
            return false;
        }
        ApplicationInstancesResponse other = (ApplicationInstancesResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApplicationInstancesResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ApplicationInstancesResponse(super=" + super.toString() + ")";
    }

    public static class ApplicationInstancesResponseBuilder {
        private ArrayList<String> instances$key;
        private ArrayList<ApplicationInstanceInfo> instances$value;

        ApplicationInstancesResponseBuilder() {
        }

        public ApplicationInstancesResponseBuilder instance(String instanceKey, ApplicationInstanceInfo instanceValue) {
            if (this.instances$key == null) {
                this.instances$key = new ArrayList();
                this.instances$value = new ArrayList();
            }
            this.instances$key.add(instanceKey);
            this.instances$value.add(instanceValue);
            return this;
        }

        public ApplicationInstancesResponseBuilder instances(Map<? extends String, ? extends ApplicationInstanceInfo> instances) {
            if (this.instances$key == null) {
                this.instances$key = new ArrayList();
                this.instances$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends ApplicationInstanceInfo> $lombokEntry : instances.entrySet()) {
                this.instances$key.add($lombokEntry.getKey());
                this.instances$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ApplicationInstancesResponse build() {
            Map<String, ApplicationInstanceInfo> instances;
            switch (this.instances$key == null ? 0 : this.instances$key.size()) {
                case 0: {
                    instances = Collections.emptyMap();
                    break;
                }
                case 1: {
                    instances = Collections.singletonMap(this.instances$key.get(0), this.instances$value.get(0));
                    break;
                }
                default: {
                    instances = new LinkedHashMap<String, ApplicationInstanceInfo>(this.instances$key.size() < 0x40000000 ? 1 + this.instances$key.size() + (this.instances$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.instances$key.size(); ++$i) {
                        instances.put(this.instances$key.get($i), this.instances$value.get($i));
                    }
                    instances = Collections.unmodifiableMap(instances);
                }
            }
            return new ApplicationInstancesResponse(instances);
        }

        public String toString() {
            return "ApplicationInstancesResponse.ApplicationInstancesResponseBuilder(instances$key=" + this.instances$key + ", instances$value=" + this.instances$value + ")";
        }
    }
}

