/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ApplicationStatisticsResponse
extends HashMap<String, InstanceStats> {
    private static final long serialVersionUID = 5833542672981662359L;

    ApplicationStatisticsResponse() {
    }

    ApplicationStatisticsResponse(Map<String, InstanceStats> instances) {
        super(instances);
    }

    public static ApplicationStatisticsResponseBuilder builder() {
        return new ApplicationStatisticsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationStatisticsResponse)) {
            return false;
        }
        ApplicationStatisticsResponse other = (ApplicationStatisticsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApplicationStatisticsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ApplicationStatisticsResponse(super=" + super.toString() + ")";
    }

    public static class ApplicationStatisticsResponseBuilder {
        private ArrayList<String> instances$key;
        private ArrayList<InstanceStats> instances$value;

        ApplicationStatisticsResponseBuilder() {
        }

        public ApplicationStatisticsResponseBuilder instance(String instanceKey, InstanceStats instanceValue) {
            if (this.instances$key == null) {
                this.instances$key = new ArrayList();
                this.instances$value = new ArrayList();
            }
            this.instances$key.add(instanceKey);
            this.instances$value.add(instanceValue);
            return this;
        }

        public ApplicationStatisticsResponseBuilder instances(Map<? extends String, ? extends InstanceStats> instances) {
            if (this.instances$key == null) {
                this.instances$key = new ArrayList();
                this.instances$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends InstanceStats> $lombokEntry : instances.entrySet()) {
                this.instances$key.add($lombokEntry.getKey());
                this.instances$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ApplicationStatisticsResponse build() {
            Map<String, InstanceStats> instances;
            switch (this.instances$key == null ? 0 : this.instances$key.size()) {
                case 0: {
                    instances = Collections.emptyMap();
                    break;
                }
                case 1: {
                    instances = Collections.singletonMap(this.instances$key.get(0), this.instances$value.get(0));
                    break;
                }
                default: {
                    instances = new LinkedHashMap<String, InstanceStats>(this.instances$key.size() < 0x40000000 ? 1 + this.instances$key.size() + (this.instances$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.instances$key.size(); ++$i) {
                        instances.put(this.instances$key.get($i), this.instances$value.get($i));
                    }
                    instances = Collections.unmodifiableMap(instances);
                }
            }
            return new ApplicationStatisticsResponse(instances);
        }

        public String toString() {
            return "ApplicationStatisticsResponse.ApplicationStatisticsResponseBuilder(instances$key=" + this.instances$key + ", instances$value=" + this.instances$value + ")";
        }
    }

    public static final class InstanceStats {
        private final String state;
        private final Statistics statistics;

        InstanceStats(@JsonProperty(value="state") String state, @JsonProperty(value="stats") Statistics statistics) {
            this.state = state;
            this.statistics = statistics;
        }

        public static InstanceStatsBuilder builder() {
            return new InstanceStatsBuilder();
        }

        public String getState() {
            return this.state;
        }

        public Statistics getStatistics() {
            return this.statistics;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceStats)) {
                return false;
            }
            InstanceStats other = (InstanceStats)o;
            String this$state = this.getState();
            String other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            Statistics this$statistics = this.getStatistics();
            Statistics other$statistics = other.getStatistics();
            return !(this$statistics == null ? other$statistics != null : !((Object)this$statistics).equals(other$statistics));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            Statistics $statistics = this.getStatistics();
            result = result * 59 + ($statistics == null ? 43 : ((Object)$statistics).hashCode());
            return result;
        }

        public String toString() {
            return "ApplicationStatisticsResponse.InstanceStats(state=" + this.getState() + ", statistics=" + this.getStatistics() + ")";
        }

        public static class InstanceStatsBuilder {
            private String state;
            private Statistics statistics;

            InstanceStatsBuilder() {
            }

            public InstanceStatsBuilder state(String state) {
                this.state = state;
                return this;
            }

            public InstanceStatsBuilder statistics(Statistics statistics) {
                this.statistics = statistics;
                return this;
            }

            public InstanceStats build() {
                return new InstanceStats(this.state, this.statistics);
            }

            public String toString() {
                return "ApplicationStatisticsResponse.InstanceStats.InstanceStatsBuilder(state=" + this.state + ", statistics=" + this.statistics + ")";
            }
        }

        public static final class Statistics {
            private final Long diskQuota;
            private final Integer fdsQuota;
            private final String host;
            private final Long memoryQuota;
            private final String name;
            private final Integer port;
            private final Long uptime;
            private final List<String> uris;
            private final Usage usage;

            Statistics(@JsonProperty(value="disk_quota") Long diskQuota, @JsonProperty(value="fds_quota") Integer fdsQuota, @JsonProperty(value="host") String host, @JsonProperty(value="mem_quota") Long memoryQuota, @JsonProperty(value="name") String name, @JsonProperty(value="port") Integer port, @JsonProperty(value="uptime") Long uptime, @JsonProperty(value="uris") List<String> uris, @JsonProperty(value="usage") Usage usage) {
                this.diskQuota = diskQuota;
                this.fdsQuota = fdsQuota;
                this.host = host;
                this.memoryQuota = memoryQuota;
                this.name = name;
                this.port = port;
                this.uptime = uptime;
                this.uris = uris;
                this.usage = usage;
            }

            public static StatisticsBuilder builder() {
                return new StatisticsBuilder();
            }

            public Long getDiskQuota() {
                return this.diskQuota;
            }

            public Integer getFdsQuota() {
                return this.fdsQuota;
            }

            public String getHost() {
                return this.host;
            }

            public Long getMemoryQuota() {
                return this.memoryQuota;
            }

            public String getName() {
                return this.name;
            }

            public Integer getPort() {
                return this.port;
            }

            public Long getUptime() {
                return this.uptime;
            }

            public List<String> getUris() {
                return this.uris;
            }

            public Usage getUsage() {
                return this.usage;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Statistics)) {
                    return false;
                }
                Statistics other = (Statistics)o;
                Long this$diskQuota = this.getDiskQuota();
                Long other$diskQuota = other.getDiskQuota();
                if (this$diskQuota == null ? other$diskQuota != null : !((Object)this$diskQuota).equals(other$diskQuota)) {
                    return false;
                }
                Integer this$fdsQuota = this.getFdsQuota();
                Integer other$fdsQuota = other.getFdsQuota();
                if (this$fdsQuota == null ? other$fdsQuota != null : !((Object)this$fdsQuota).equals(other$fdsQuota)) {
                    return false;
                }
                String this$host = this.getHost();
                String other$host = other.getHost();
                if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                    return false;
                }
                Long this$memoryQuota = this.getMemoryQuota();
                Long other$memoryQuota = other.getMemoryQuota();
                if (this$memoryQuota == null ? other$memoryQuota != null : !((Object)this$memoryQuota).equals(other$memoryQuota)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                Integer this$port = this.getPort();
                Integer other$port = other.getPort();
                if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                    return false;
                }
                Long this$uptime = this.getUptime();
                Long other$uptime = other.getUptime();
                if (this$uptime == null ? other$uptime != null : !((Object)this$uptime).equals(other$uptime)) {
                    return false;
                }
                List<String> this$uris = this.getUris();
                List<String> other$uris = other.getUris();
                if (this$uris == null ? other$uris != null : !((Object)this$uris).equals(other$uris)) {
                    return false;
                }
                Usage this$usage = this.getUsage();
                Usage other$usage = other.getUsage();
                return !(this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $diskQuota = this.getDiskQuota();
                result = result * 59 + ($diskQuota == null ? 43 : ((Object)$diskQuota).hashCode());
                Integer $fdsQuota = this.getFdsQuota();
                result = result * 59 + ($fdsQuota == null ? 43 : ((Object)$fdsQuota).hashCode());
                String $host = this.getHost();
                result = result * 59 + ($host == null ? 43 : $host.hashCode());
                Long $memoryQuota = this.getMemoryQuota();
                result = result * 59 + ($memoryQuota == null ? 43 : ((Object)$memoryQuota).hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                Integer $port = this.getPort();
                result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
                Long $uptime = this.getUptime();
                result = result * 59 + ($uptime == null ? 43 : ((Object)$uptime).hashCode());
                List<String> $uris = this.getUris();
                result = result * 59 + ($uris == null ? 43 : ((Object)$uris).hashCode());
                Usage $usage = this.getUsage();
                result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
                return result;
            }

            public String toString() {
                return "ApplicationStatisticsResponse.InstanceStats.Statistics(diskQuota=" + this.getDiskQuota() + ", fdsQuota=" + this.getFdsQuota() + ", host=" + this.getHost() + ", memoryQuota=" + this.getMemoryQuota() + ", name=" + this.getName() + ", port=" + this.getPort() + ", uptime=" + this.getUptime() + ", uris=" + this.getUris() + ", usage=" + this.getUsage() + ")";
            }

            public static class StatisticsBuilder {
                private Long diskQuota;
                private Integer fdsQuota;
                private String host;
                private Long memoryQuota;
                private String name;
                private Integer port;
                private Long uptime;
                private ArrayList<String> uris;
                private Usage usage;

                StatisticsBuilder() {
                }

                public StatisticsBuilder diskQuota(Long diskQuota) {
                    this.diskQuota = diskQuota;
                    return this;
                }

                public StatisticsBuilder fdsQuota(Integer fdsQuota) {
                    this.fdsQuota = fdsQuota;
                    return this;
                }

                public StatisticsBuilder host(String host) {
                    this.host = host;
                    return this;
                }

                public StatisticsBuilder memoryQuota(Long memoryQuota) {
                    this.memoryQuota = memoryQuota;
                    return this;
                }

                public StatisticsBuilder name(String name) {
                    this.name = name;
                    return this;
                }

                public StatisticsBuilder port(Integer port) {
                    this.port = port;
                    return this;
                }

                public StatisticsBuilder uptime(Long uptime) {
                    this.uptime = uptime;
                    return this;
                }

                public StatisticsBuilder uri(String uri) {
                    if (this.uris == null) {
                        this.uris = new ArrayList();
                    }
                    this.uris.add(uri);
                    return this;
                }

                public StatisticsBuilder uris(Collection<? extends String> uris) {
                    if (this.uris == null) {
                        this.uris = new ArrayList();
                    }
                    this.uris.addAll(uris);
                    return this;
                }

                public StatisticsBuilder usage(Usage usage) {
                    this.usage = usage;
                    return this;
                }

                public Statistics build() {
                    List<String> uris;
                    switch (this.uris == null ? 0 : this.uris.size()) {
                        case 0: {
                            uris = Collections.emptyList();
                            break;
                        }
                        case 1: {
                            uris = Collections.singletonList(this.uris.get(0));
                            break;
                        }
                        default: {
                            uris = Collections.unmodifiableList(new ArrayList<String>(this.uris));
                        }
                    }
                    return new Statistics(this.diskQuota, this.fdsQuota, this.host, this.memoryQuota, this.name, this.port, this.uptime, uris, this.usage);
                }

                public String toString() {
                    return "ApplicationStatisticsResponse.InstanceStats.Statistics.StatisticsBuilder(diskQuota=" + this.diskQuota + ", fdsQuota=" + this.fdsQuota + ", host=" + this.host + ", memoryQuota=" + this.memoryQuota + ", name=" + this.name + ", port=" + this.port + ", uptime=" + this.uptime + ", uris=" + this.uris + ", usage=" + this.usage + ")";
                }
            }

            public static final class Usage {
                private final Double cpu;
                private final Long disk;
                private final Long memory;
                private final String time;

                Usage(@JsonProperty(value="cpu") Double cpu, @JsonProperty(value="disk") Long disk, @JsonProperty(value="mem") Long memory, @JsonProperty(value="time") String time) {
                    this.cpu = cpu;
                    this.disk = disk;
                    this.memory = memory;
                    this.time = time;
                }

                public static UsageBuilder builder() {
                    return new UsageBuilder();
                }

                public Double getCpu() {
                    return this.cpu;
                }

                public Long getDisk() {
                    return this.disk;
                }

                public Long getMemory() {
                    return this.memory;
                }

                public String getTime() {
                    return this.time;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Usage)) {
                        return false;
                    }
                    Usage other = (Usage)o;
                    Double this$cpu = this.getCpu();
                    Double other$cpu = other.getCpu();
                    if (this$cpu == null ? other$cpu != null : !((Object)this$cpu).equals(other$cpu)) {
                        return false;
                    }
                    Long this$disk = this.getDisk();
                    Long other$disk = other.getDisk();
                    if (this$disk == null ? other$disk != null : !((Object)this$disk).equals(other$disk)) {
                        return false;
                    }
                    Long this$memory = this.getMemory();
                    Long other$memory = other.getMemory();
                    if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
                        return false;
                    }
                    String this$time = this.getTime();
                    String other$time = other.getTime();
                    return !(this$time == null ? other$time != null : !this$time.equals(other$time));
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Double $cpu = this.getCpu();
                    result = result * 59 + ($cpu == null ? 43 : ((Object)$cpu).hashCode());
                    Long $disk = this.getDisk();
                    result = result * 59 + ($disk == null ? 43 : ((Object)$disk).hashCode());
                    Long $memory = this.getMemory();
                    result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
                    String $time = this.getTime();
                    result = result * 59 + ($time == null ? 43 : $time.hashCode());
                    return result;
                }

                public String toString() {
                    return "ApplicationStatisticsResponse.InstanceStats.Statistics.Usage(cpu=" + this.getCpu() + ", disk=" + this.getDisk() + ", memory=" + this.getMemory() + ", time=" + this.getTime() + ")";
                }

                public static class UsageBuilder {
                    private Double cpu;
                    private Long disk;
                    private Long memory;
                    private String time;

                    UsageBuilder() {
                    }

                    public UsageBuilder cpu(Double cpu) {
                        this.cpu = cpu;
                        return this;
                    }

                    public UsageBuilder disk(Long disk) {
                        this.disk = disk;
                        return this;
                    }

                    public UsageBuilder memory(Long memory) {
                        this.memory = memory;
                        return this;
                    }

                    public UsageBuilder time(String time) {
                        this.time = time;
                        return this;
                    }

                    public Usage build() {
                        return new Usage(this.cpu, this.disk, this.memory, this.time);
                    }

                    public String toString() {
                        return "ApplicationStatisticsResponse.InstanceStats.Statistics.Usage.UsageBuilder(cpu=" + this.cpu + ", disk=" + this.disk + ", memory=" + this.memory + ", time=" + this.time + ")";
                    }
                }
            }
        }
    }
}

