/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class AssociateApplicationRouteRequest
implements Validatable {
    private final String applicationId;
    private final String routeId;

    AssociateApplicationRouteRequest(String applicationId, String routeId) {
        this.applicationId = applicationId;
        this.routeId = routeId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.routeId == null) {
            builder.message("route id must be specified");
        }
        return builder.build();
    }

    public static AssociateApplicationRouteRequestBuilder builder() {
        return new AssociateApplicationRouteRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssociateApplicationRouteRequest)) {
            return false;
        }
        AssociateApplicationRouteRequest other = (AssociateApplicationRouteRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$routeId = this.getRouteId();
        String other$routeId = other.getRouteId();
        return !(this$routeId == null ? other$routeId != null : !this$routeId.equals(other$routeId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $routeId = this.getRouteId();
        result = result * 59 + ($routeId == null ? 43 : $routeId.hashCode());
        return result;
    }

    public String toString() {
        return "AssociateApplicationRouteRequest(super=" + super.toString() + ", applicationId=" + this.getApplicationId() + ", routeId=" + this.getRouteId() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonIgnore
    public String getRouteId() {
        return this.routeId;
    }

    public static class AssociateApplicationRouteRequestBuilder {
        private String applicationId;
        private String routeId;

        AssociateApplicationRouteRequestBuilder() {
        }

        public AssociateApplicationRouteRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public AssociateApplicationRouteRequestBuilder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        public AssociateApplicationRouteRequest build() {
            return new AssociateApplicationRouteRequest(this.applicationId, this.routeId);
        }

        public String toString() {
            return "AssociateApplicationRouteRequest.AssociateApplicationRouteRequestBuilder(applicationId=" + this.applicationId + ", routeId=" + this.routeId + ")";
        }
    }
}

