/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CopyApplicationRequest
implements Validatable {
    private final String applicationId;
    private final String sourceApplicationId;

    CopyApplicationRequest(String applicationId, String sourceApplicationId) {
        this.applicationId = applicationId;
        this.sourceApplicationId = sourceApplicationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.sourceApplicationId == null) {
            builder.message("source application id must be specified");
        }
        return builder.build();
    }

    public static CopyApplicationRequestBuilder builder() {
        return new CopyApplicationRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyApplicationRequest)) {
            return false;
        }
        CopyApplicationRequest other = (CopyApplicationRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$sourceApplicationId = this.getSourceApplicationId();
        String other$sourceApplicationId = other.getSourceApplicationId();
        return !(this$sourceApplicationId == null ? other$sourceApplicationId != null : !this$sourceApplicationId.equals(other$sourceApplicationId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $sourceApplicationId = this.getSourceApplicationId();
        result = result * 59 + ($sourceApplicationId == null ? 43 : $sourceApplicationId.hashCode());
        return result;
    }

    public String toString() {
        return "CopyApplicationRequest(applicationId=" + this.getApplicationId() + ", sourceApplicationId=" + this.getSourceApplicationId() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="source_app_guid")
    public String getSourceApplicationId() {
        return this.sourceApplicationId;
    }

    public static class CopyApplicationRequestBuilder {
        private String applicationId;
        private String sourceApplicationId;

        CopyApplicationRequestBuilder() {
        }

        public CopyApplicationRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public CopyApplicationRequestBuilder sourceApplicationId(String sourceApplicationId) {
            this.sourceApplicationId = sourceApplicationId;
            return this;
        }

        public CopyApplicationRequest build() {
            return new CopyApplicationRequest(this.applicationId, this.sourceApplicationId);
        }

        public String toString() {
            return "CopyApplicationRequest.CopyApplicationRequestBuilder(applicationId=" + this.applicationId + ", sourceApplicationId=" + this.sourceApplicationId + ")";
        }
    }
}

