/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateApplicationRequest
implements Validatable {
    private final String buildpack;
    private final String command;
    private final Boolean console;
    private final Boolean debug;
    private final String detectedStartCommand;
    private final Boolean diego;
    private final Integer diskQuota;
    private final Map<String, Object> dockerCredentialsJsons;
    private final String dockerImage;
    private final Boolean enableSsh;
    private final Map<String, Object> environmentJsons;
    private final Integer healthCheckTimeout;
    private final String healthCheckType;
    private final Integer instances;
    private final Integer memory;
    private final String name;
    private final List<Integer> ports;
    private final Boolean production;
    private final String spaceId;
    private final String stackId;
    private final String stagingFailedDescription;
    private final String stagingFailedReason;
    private final String state;

    CreateApplicationRequest(String buildpack, String command, Boolean console, Boolean debug, String detectedStartCommand, Boolean diego, Integer diskQuota, Map<String, Object> dockerCredentialsJsons, String dockerImage, Boolean enableSsh, Map<String, Object> environmentJsons, Integer healthCheckTimeout, String healthCheckType, Integer instances, Integer memory, String name, List<Integer> ports, Boolean production, String spaceId, String stackId, String stagingFailedDescription, String stagingFailedReason, String state) {
        this.buildpack = buildpack;
        this.command = command;
        this.console = console;
        this.debug = debug;
        this.detectedStartCommand = detectedStartCommand;
        this.diego = diego;
        this.diskQuota = diskQuota;
        this.dockerCredentialsJsons = dockerCredentialsJsons;
        this.dockerImage = dockerImage;
        this.enableSsh = enableSsh;
        this.environmentJsons = environmentJsons;
        this.healthCheckTimeout = healthCheckTimeout;
        this.healthCheckType = healthCheckType;
        this.instances = instances;
        this.memory = memory;
        this.name = name;
        this.ports = ports;
        this.production = production;
        this.spaceId = spaceId;
        this.stackId = stackId;
        this.stagingFailedDescription = stagingFailedDescription;
        this.stagingFailedReason = stagingFailedReason;
        this.state = state;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static CreateApplicationRequestBuilder builder() {
        return new CreateApplicationRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)o;
        String this$buildpack = this.getBuildpack();
        String other$buildpack = other.getBuildpack();
        if (this$buildpack == null ? other$buildpack != null : !this$buildpack.equals(other$buildpack)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        Boolean this$console = this.getConsole();
        Boolean other$console = other.getConsole();
        if (this$console == null ? other$console != null : !((Object)this$console).equals(other$console)) {
            return false;
        }
        Boolean this$debug = this.getDebug();
        Boolean other$debug = other.getDebug();
        if (this$debug == null ? other$debug != null : !((Object)this$debug).equals(other$debug)) {
            return false;
        }
        String this$detectedStartCommand = this.getDetectedStartCommand();
        String other$detectedStartCommand = other.getDetectedStartCommand();
        if (this$detectedStartCommand == null ? other$detectedStartCommand != null : !this$detectedStartCommand.equals(other$detectedStartCommand)) {
            return false;
        }
        Boolean this$diego = this.getDiego();
        Boolean other$diego = other.getDiego();
        if (this$diego == null ? other$diego != null : !((Object)this$diego).equals(other$diego)) {
            return false;
        }
        Integer this$diskQuota = this.getDiskQuota();
        Integer other$diskQuota = other.getDiskQuota();
        if (this$diskQuota == null ? other$diskQuota != null : !((Object)this$diskQuota).equals(other$diskQuota)) {
            return false;
        }
        Map<String, Object> this$dockerCredentialsJsons = this.getDockerCredentialsJsons();
        Map<String, Object> other$dockerCredentialsJsons = other.getDockerCredentialsJsons();
        if (this$dockerCredentialsJsons == null ? other$dockerCredentialsJsons != null : !((Object)this$dockerCredentialsJsons).equals(other$dockerCredentialsJsons)) {
            return false;
        }
        String this$dockerImage = this.getDockerImage();
        String other$dockerImage = other.getDockerImage();
        if (this$dockerImage == null ? other$dockerImage != null : !this$dockerImage.equals(other$dockerImage)) {
            return false;
        }
        Boolean this$enableSsh = this.getEnableSsh();
        Boolean other$enableSsh = other.getEnableSsh();
        if (this$enableSsh == null ? other$enableSsh != null : !((Object)this$enableSsh).equals(other$enableSsh)) {
            return false;
        }
        Map<String, Object> this$environmentJsons = this.getEnvironmentJsons();
        Map<String, Object> other$environmentJsons = other.getEnvironmentJsons();
        if (this$environmentJsons == null ? other$environmentJsons != null : !((Object)this$environmentJsons).equals(other$environmentJsons)) {
            return false;
        }
        Integer this$healthCheckTimeout = this.getHealthCheckTimeout();
        Integer other$healthCheckTimeout = other.getHealthCheckTimeout();
        if (this$healthCheckTimeout == null ? other$healthCheckTimeout != null : !((Object)this$healthCheckTimeout).equals(other$healthCheckTimeout)) {
            return false;
        }
        String this$healthCheckType = this.getHealthCheckType();
        String other$healthCheckType = other.getHealthCheckType();
        if (this$healthCheckType == null ? other$healthCheckType != null : !this$healthCheckType.equals(other$healthCheckType)) {
            return false;
        }
        Integer this$instances = this.getInstances();
        Integer other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances)) {
            return false;
        }
        Integer this$memory = this.getMemory();
        Integer other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Integer> this$ports = this.getPorts();
        List<Integer> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        Boolean this$production = this.getProduction();
        Boolean other$production = other.getProduction();
        if (this$production == null ? other$production != null : !((Object)this$production).equals(other$production)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) {
            return false;
        }
        String this$stackId = this.getStackId();
        String other$stackId = other.getStackId();
        if (this$stackId == null ? other$stackId != null : !this$stackId.equals(other$stackId)) {
            return false;
        }
        String this$stagingFailedDescription = this.getStagingFailedDescription();
        String other$stagingFailedDescription = other.getStagingFailedDescription();
        if (this$stagingFailedDescription == null ? other$stagingFailedDescription != null : !this$stagingFailedDescription.equals(other$stagingFailedDescription)) {
            return false;
        }
        String this$stagingFailedReason = this.getStagingFailedReason();
        String other$stagingFailedReason = other.getStagingFailedReason();
        if (this$stagingFailedReason == null ? other$stagingFailedReason != null : !this$stagingFailedReason.equals(other$stagingFailedReason)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        return !(this$state == null ? other$state != null : !this$state.equals(other$state));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $buildpack = this.getBuildpack();
        result = result * 59 + ($buildpack == null ? 43 : $buildpack.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        Boolean $console = this.getConsole();
        result = result * 59 + ($console == null ? 43 : ((Object)$console).hashCode());
        Boolean $debug = this.getDebug();
        result = result * 59 + ($debug == null ? 43 : ((Object)$debug).hashCode());
        String $detectedStartCommand = this.getDetectedStartCommand();
        result = result * 59 + ($detectedStartCommand == null ? 43 : $detectedStartCommand.hashCode());
        Boolean $diego = this.getDiego();
        result = result * 59 + ($diego == null ? 43 : ((Object)$diego).hashCode());
        Integer $diskQuota = this.getDiskQuota();
        result = result * 59 + ($diskQuota == null ? 43 : ((Object)$diskQuota).hashCode());
        Map<String, Object> $dockerCredentialsJsons = this.getDockerCredentialsJsons();
        result = result * 59 + ($dockerCredentialsJsons == null ? 43 : ((Object)$dockerCredentialsJsons).hashCode());
        String $dockerImage = this.getDockerImage();
        result = result * 59 + ($dockerImage == null ? 43 : $dockerImage.hashCode());
        Boolean $enableSsh = this.getEnableSsh();
        result = result * 59 + ($enableSsh == null ? 43 : ((Object)$enableSsh).hashCode());
        Map<String, Object> $environmentJsons = this.getEnvironmentJsons();
        result = result * 59 + ($environmentJsons == null ? 43 : ((Object)$environmentJsons).hashCode());
        Integer $healthCheckTimeout = this.getHealthCheckTimeout();
        result = result * 59 + ($healthCheckTimeout == null ? 43 : ((Object)$healthCheckTimeout).hashCode());
        String $healthCheckType = this.getHealthCheckType();
        result = result * 59 + ($healthCheckType == null ? 43 : $healthCheckType.hashCode());
        Integer $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        Integer $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Integer> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        Boolean $production = this.getProduction();
        result = result * 59 + ($production == null ? 43 : ((Object)$production).hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        String $stackId = this.getStackId();
        result = result * 59 + ($stackId == null ? 43 : $stackId.hashCode());
        String $stagingFailedDescription = this.getStagingFailedDescription();
        result = result * 59 + ($stagingFailedDescription == null ? 43 : $stagingFailedDescription.hashCode());
        String $stagingFailedReason = this.getStagingFailedReason();
        result = result * 59 + ($stagingFailedReason == null ? 43 : $stagingFailedReason.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        return result;
    }

    public String toString() {
        return "CreateApplicationRequest(buildpack=" + this.getBuildpack() + ", command=" + this.getCommand() + ", console=" + this.getConsole() + ", debug=" + this.getDebug() + ", detectedStartCommand=" + this.getDetectedStartCommand() + ", diego=" + this.getDiego() + ", diskQuota=" + this.getDiskQuota() + ", dockerCredentialsJsons=" + this.getDockerCredentialsJsons() + ", dockerImage=" + this.getDockerImage() + ", enableSsh=" + this.getEnableSsh() + ", environmentJsons=" + this.getEnvironmentJsons() + ", healthCheckTimeout=" + this.getHealthCheckTimeout() + ", healthCheckType=" + this.getHealthCheckType() + ", instances=" + this.getInstances() + ", memory=" + this.getMemory() + ", name=" + this.getName() + ", ports=" + this.getPorts() + ", production=" + this.getProduction() + ", spaceId=" + this.getSpaceId() + ", stackId=" + this.getStackId() + ", stagingFailedDescription=" + this.getStagingFailedDescription() + ", stagingFailedReason=" + this.getStagingFailedReason() + ", state=" + this.getState() + ")";
    }

    @JsonProperty(value="buildpack")
    public String getBuildpack() {
        return this.buildpack;
    }

    @JsonProperty(value="command")
    public String getCommand() {
        return this.command;
    }

    @JsonProperty(value="console")
    @Deprecated
    public Boolean getConsole() {
        return this.console;
    }

    @JsonProperty(value="debug")
    @Deprecated
    public Boolean getDebug() {
        return this.debug;
    }

    @JsonProperty(value="detected_start_command")
    public String getDetectedStartCommand() {
        return this.detectedStartCommand;
    }

    @JsonProperty(value="diego")
    public Boolean getDiego() {
        return this.diego;
    }

    @JsonProperty(value="disk_quota")
    public Integer getDiskQuota() {
        return this.diskQuota;
    }

    @JsonProperty(value="docker_credentials_json")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getDockerCredentialsJsons() {
        return this.dockerCredentialsJsons;
    }

    @JsonProperty(value="docker_image")
    public String getDockerImage() {
        return this.dockerImage;
    }

    @JsonProperty(value="enable_ssh")
    public Boolean getEnableSsh() {
        return this.enableSsh;
    }

    @JsonProperty(value="environment_json")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getEnvironmentJsons() {
        return this.environmentJsons;
    }

    @JsonProperty(value="health_check_timeout")
    public Integer getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    @JsonProperty(value="health_check_type")
    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    @JsonProperty(value="instances")
    public Integer getInstances() {
        return this.instances;
    }

    @JsonProperty(value="memory")
    public Integer getMemory() {
        return this.memory;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="ports")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Integer> getPorts() {
        return this.ports;
    }

    @JsonProperty(value="production")
    @Deprecated
    public Boolean getProduction() {
        return this.production;
    }

    @JsonProperty(value="space_guid")
    public String getSpaceId() {
        return this.spaceId;
    }

    @JsonProperty(value="stack_guid")
    public String getStackId() {
        return this.stackId;
    }

    @JsonProperty(value="staging_failed_description")
    public String getStagingFailedDescription() {
        return this.stagingFailedDescription;
    }

    @JsonProperty(value="staging_failed_reason")
    public String getStagingFailedReason() {
        return this.stagingFailedReason;
    }

    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    public static class CreateApplicationRequestBuilder {
        private String buildpack;
        private String command;
        private Boolean console;
        private Boolean debug;
        private String detectedStartCommand;
        private Boolean diego;
        private Integer diskQuota;
        private ArrayList<String> dockerCredentialsJsons$key;
        private ArrayList<Object> dockerCredentialsJsons$value;
        private String dockerImage;
        private Boolean enableSsh;
        private ArrayList<String> environmentJsons$key;
        private ArrayList<Object> environmentJsons$value;
        private Integer healthCheckTimeout;
        private String healthCheckType;
        private Integer instances;
        private Integer memory;
        private String name;
        private ArrayList<Integer> ports;
        private Boolean production;
        private String spaceId;
        private String stackId;
        private String stagingFailedDescription;
        private String stagingFailedReason;
        private String state;

        CreateApplicationRequestBuilder() {
        }

        public CreateApplicationRequestBuilder buildpack(String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        public CreateApplicationRequestBuilder command(String command) {
            this.command = command;
            return this;
        }

        public CreateApplicationRequestBuilder console(Boolean console) {
            this.console = console;
            return this;
        }

        public CreateApplicationRequestBuilder debug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public CreateApplicationRequestBuilder detectedStartCommand(String detectedStartCommand) {
            this.detectedStartCommand = detectedStartCommand;
            return this;
        }

        public CreateApplicationRequestBuilder diego(Boolean diego) {
            this.diego = diego;
            return this;
        }

        public CreateApplicationRequestBuilder diskQuota(Integer diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        public CreateApplicationRequestBuilder dockerCredentialsJson(String dockerCredentialsJsonKey, Object dockerCredentialsJsonValue) {
            if (this.dockerCredentialsJsons$key == null) {
                this.dockerCredentialsJsons$key = new ArrayList();
                this.dockerCredentialsJsons$value = new ArrayList();
            }
            this.dockerCredentialsJsons$key.add(dockerCredentialsJsonKey);
            this.dockerCredentialsJsons$value.add(dockerCredentialsJsonValue);
            return this;
        }

        public CreateApplicationRequestBuilder dockerCredentialsJsons(Map<? extends String, ? extends Object> dockerCredentialsJsons) {
            if (this.dockerCredentialsJsons$key == null) {
                this.dockerCredentialsJsons$key = new ArrayList();
                this.dockerCredentialsJsons$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : dockerCredentialsJsons.entrySet()) {
                this.dockerCredentialsJsons$key.add($lombokEntry.getKey());
                this.dockerCredentialsJsons$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateApplicationRequestBuilder dockerImage(String dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        public CreateApplicationRequestBuilder enableSsh(Boolean enableSsh) {
            this.enableSsh = enableSsh;
            return this;
        }

        public CreateApplicationRequestBuilder environmentJson(String environmentJsonKey, Object environmentJsonValue) {
            if (this.environmentJsons$key == null) {
                this.environmentJsons$key = new ArrayList();
                this.environmentJsons$value = new ArrayList();
            }
            this.environmentJsons$key.add(environmentJsonKey);
            this.environmentJsons$value.add(environmentJsonValue);
            return this;
        }

        public CreateApplicationRequestBuilder environmentJsons(Map<? extends String, ? extends Object> environmentJsons) {
            if (this.environmentJsons$key == null) {
                this.environmentJsons$key = new ArrayList();
                this.environmentJsons$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : environmentJsons.entrySet()) {
                this.environmentJsons$key.add($lombokEntry.getKey());
                this.environmentJsons$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateApplicationRequestBuilder healthCheckTimeout(Integer healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
            return this;
        }

        public CreateApplicationRequestBuilder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public CreateApplicationRequestBuilder instances(Integer instances) {
            this.instances = instances;
            return this;
        }

        public CreateApplicationRequestBuilder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public CreateApplicationRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateApplicationRequestBuilder port(Integer port) {
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.add(port);
            return this;
        }

        public CreateApplicationRequestBuilder ports(Collection<? extends Integer> ports) {
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.addAll(ports);
            return this;
        }

        public CreateApplicationRequestBuilder production(Boolean production) {
            this.production = production;
            return this;
        }

        public CreateApplicationRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public CreateApplicationRequestBuilder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public CreateApplicationRequestBuilder stagingFailedDescription(String stagingFailedDescription) {
            this.stagingFailedDescription = stagingFailedDescription;
            return this;
        }

        public CreateApplicationRequestBuilder stagingFailedReason(String stagingFailedReason) {
            this.stagingFailedReason = stagingFailedReason;
            return this;
        }

        public CreateApplicationRequestBuilder state(String state) {
            this.state = state;
            return this;
        }

        public CreateApplicationRequest build() {
            List<Integer> ports;
            Map<Object, Object> environmentJsons;
            Map<Object, Object> dockerCredentialsJsons;
            switch (this.dockerCredentialsJsons$key == null ? 0 : this.dockerCredentialsJsons$key.size()) {
                case 0: {
                    dockerCredentialsJsons = Collections.emptyMap();
                    break;
                }
                case 1: {
                    dockerCredentialsJsons = Collections.singletonMap(this.dockerCredentialsJsons$key.get(0), this.dockerCredentialsJsons$value.get(0));
                    break;
                }
                default: {
                    dockerCredentialsJsons = new LinkedHashMap(this.dockerCredentialsJsons$key.size() < 0x40000000 ? 1 + this.dockerCredentialsJsons$key.size() + (this.dockerCredentialsJsons$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.dockerCredentialsJsons$key.size(); ++$i) {
                        dockerCredentialsJsons.put(this.dockerCredentialsJsons$key.get($i), this.dockerCredentialsJsons$value.get($i));
                    }
                    dockerCredentialsJsons = Collections.unmodifiableMap(dockerCredentialsJsons);
                }
            }
            switch (this.environmentJsons$key == null ? 0 : this.environmentJsons$key.size()) {
                case 0: {
                    environmentJsons = Collections.emptyMap();
                    break;
                }
                case 1: {
                    environmentJsons = Collections.singletonMap(this.environmentJsons$key.get(0), this.environmentJsons$value.get(0));
                    break;
                }
                default: {
                    environmentJsons = new LinkedHashMap(this.environmentJsons$key.size() < 0x40000000 ? 1 + this.environmentJsons$key.size() + (this.environmentJsons$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.environmentJsons$key.size(); ++$i) {
                        environmentJsons.put(this.environmentJsons$key.get($i), this.environmentJsons$value.get($i));
                    }
                    environmentJsons = Collections.unmodifiableMap(environmentJsons);
                }
            }
            switch (this.ports == null ? 0 : this.ports.size()) {
                case 0: {
                    ports = Collections.emptyList();
                    break;
                }
                case 1: {
                    ports = Collections.singletonList(this.ports.get(0));
                    break;
                }
                default: {
                    ports = Collections.unmodifiableList(new ArrayList<Integer>(this.ports));
                }
            }
            return new CreateApplicationRequest(this.buildpack, this.command, this.console, this.debug, this.detectedStartCommand, this.diego, this.diskQuota, dockerCredentialsJsons, this.dockerImage, this.enableSsh, environmentJsons, this.healthCheckTimeout, this.healthCheckType, this.instances, this.memory, this.name, ports, this.production, this.spaceId, this.stackId, this.stagingFailedDescription, this.stagingFailedReason, this.state);
        }

        public String toString() {
            return "CreateApplicationRequest.CreateApplicationRequestBuilder(buildpack=" + this.buildpack + ", command=" + this.command + ", console=" + this.console + ", debug=" + this.debug + ", detectedStartCommand=" + this.detectedStartCommand + ", diego=" + this.diego + ", diskQuota=" + this.diskQuota + ", dockerCredentialsJsons$key=" + this.dockerCredentialsJsons$key + ", dockerCredentialsJsons$value=" + this.dockerCredentialsJsons$value + ", dockerImage=" + this.dockerImage + ", enableSsh=" + this.enableSsh + ", environmentJsons$key=" + this.environmentJsons$key + ", environmentJsons$value=" + this.environmentJsons$value + ", healthCheckTimeout=" + this.healthCheckTimeout + ", healthCheckType=" + this.healthCheckType + ", instances=" + this.instances + ", memory=" + this.memory + ", name=" + this.name + ", ports=" + this.ports + ", production=" + this.production + ", spaceId=" + this.spaceId + ", stackId=" + this.stackId + ", stagingFailedDescription=" + this.stagingFailedDescription + ", stagingFailedReason=" + this.stagingFailedReason + ", state=" + this.state + ")";
        }
    }
}

