/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DownloadApplicationRequest
implements Validatable {
    private final String applicationId;

    DownloadApplicationRequest(String applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        return builder.build();
    }

    public static DownloadApplicationRequestBuilder builder() {
        return new DownloadApplicationRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloadApplicationRequest)) {
            return false;
        }
        DownloadApplicationRequest other = (DownloadApplicationRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        return !(this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        return result;
    }

    public String toString() {
        return "DownloadApplicationRequest(applicationId=" + this.getApplicationId() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    public static class DownloadApplicationRequestBuilder {
        private String applicationId;

        DownloadApplicationRequestBuilder() {
        }

        public DownloadApplicationRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public DownloadApplicationRequest build() {
            return new DownloadApplicationRequest(this.applicationId);
        }

        public String toString() {
            return "DownloadApplicationRequest.DownloadApplicationRequestBuilder(applicationId=" + this.applicationId + ")";
        }
    }
}

