/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListApplicationRoutesRequest
extends PaginatedRequest
implements Validatable {
    private final String applicationId;
    private final List<String> domainIds;
    private final List<String> hosts;
    private final List<String> paths;
    private final List<Integer> ports;

    ListApplicationRoutesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, String applicationId, List<String> domainIds, List<String> hosts, List<String> paths, List<Integer> ports) {
        super(orderDirection, page, resultsPerPage);
        this.applicationId = applicationId;
        this.domainIds = domainIds;
        this.hosts = hosts;
        this.paths = paths;
        this.ports = ports;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        return builder.build();
    }

    public static ListApplicationRoutesRequestBuilder builder() {
        return new ListApplicationRoutesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListApplicationRoutesRequest)) {
            return false;
        }
        ListApplicationRoutesRequest other = (ListApplicationRoutesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        List<String> this$domainIds = this.getDomainIds();
        List<String> other$domainIds = other.getDomainIds();
        if (this$domainIds == null ? other$domainIds != null : !((Object)this$domainIds).equals(other$domainIds)) {
            return false;
        }
        List<String> this$hosts = this.getHosts();
        List<String> other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !((Object)this$hosts).equals(other$hosts)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        if (this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths)) {
            return false;
        }
        List<Integer> this$ports = this.getPorts();
        List<Integer> other$ports = other.getPorts();
        return !(this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListApplicationRoutesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        List<String> $domainIds = this.getDomainIds();
        result = result * 59 + ($domainIds == null ? 43 : ((Object)$domainIds).hashCode());
        List<String> $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : ((Object)$hosts).hashCode());
        List<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        List<Integer> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListApplicationRoutesRequest(super=" + super.toString() + ", applicationId=" + this.getApplicationId() + ", domainIds=" + this.getDomainIds() + ", hosts=" + this.getHosts() + ", paths=" + this.getPaths() + ", ports=" + this.getPorts() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @InFilterParameter(value="domain_guid")
    public List<String> getDomainIds() {
        return this.domainIds;
    }

    @InFilterParameter(value="host")
    public List<String> getHosts() {
        return this.hosts;
    }

    @InFilterParameter(value="path")
    public List<String> getPaths() {
        return this.paths;
    }

    @InFilterParameter(value="port")
    public List<Integer> getPorts() {
        return this.ports;
    }

    public static class ListApplicationRoutesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private String applicationId;
        private ArrayList<String> domainIds;
        private ArrayList<String> hosts;
        private ArrayList<String> paths;
        private ArrayList<Integer> ports;

        ListApplicationRoutesRequestBuilder() {
        }

        public ListApplicationRoutesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListApplicationRoutesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListApplicationRoutesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListApplicationRoutesRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public ListApplicationRoutesRequestBuilder domainId(String domainId) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList();
            }
            this.domainIds.add(domainId);
            return this;
        }

        public ListApplicationRoutesRequestBuilder domainIds(Collection<? extends String> domainIds) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList();
            }
            this.domainIds.addAll(domainIds);
            return this;
        }

        public ListApplicationRoutesRequestBuilder host(String host) {
            if (this.hosts == null) {
                this.hosts = new ArrayList();
            }
            this.hosts.add(host);
            return this;
        }

        public ListApplicationRoutesRequestBuilder hosts(Collection<? extends String> hosts) {
            if (this.hosts == null) {
                this.hosts = new ArrayList();
            }
            this.hosts.addAll(hosts);
            return this;
        }

        public ListApplicationRoutesRequestBuilder path(String path) {
            if (this.paths == null) {
                this.paths = new ArrayList();
            }
            this.paths.add(path);
            return this;
        }

        public ListApplicationRoutesRequestBuilder paths(Collection<? extends String> paths) {
            if (this.paths == null) {
                this.paths = new ArrayList();
            }
            this.paths.addAll(paths);
            return this;
        }

        public ListApplicationRoutesRequestBuilder port(Integer port) {
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.add(port);
            return this;
        }

        public ListApplicationRoutesRequestBuilder ports(Collection<? extends Integer> ports) {
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.addAll(ports);
            return this;
        }

        public ListApplicationRoutesRequest build() {
            List<Integer> ports;
            List<String> paths;
            List<String> hosts;
            List<String> domainIds;
            switch (this.domainIds == null ? 0 : this.domainIds.size()) {
                case 0: {
                    domainIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    domainIds = Collections.singletonList(this.domainIds.get(0));
                    break;
                }
                default: {
                    domainIds = Collections.unmodifiableList(new ArrayList<String>(this.domainIds));
                }
            }
            switch (this.hosts == null ? 0 : this.hosts.size()) {
                case 0: {
                    hosts = Collections.emptyList();
                    break;
                }
                case 1: {
                    hosts = Collections.singletonList(this.hosts.get(0));
                    break;
                }
                default: {
                    hosts = Collections.unmodifiableList(new ArrayList<String>(this.hosts));
                }
            }
            switch (this.paths == null ? 0 : this.paths.size()) {
                case 0: {
                    paths = Collections.emptyList();
                    break;
                }
                case 1: {
                    paths = Collections.singletonList(this.paths.get(0));
                    break;
                }
                default: {
                    paths = Collections.unmodifiableList(new ArrayList<String>(this.paths));
                }
            }
            switch (this.ports == null ? 0 : this.ports.size()) {
                case 0: {
                    ports = Collections.emptyList();
                    break;
                }
                case 1: {
                    ports = Collections.singletonList(this.ports.get(0));
                    break;
                }
                default: {
                    ports = Collections.unmodifiableList(new ArrayList<Integer>(this.ports));
                }
            }
            return new ListApplicationRoutesRequest(this.orderDirection, this.page, this.resultsPerPage, this.applicationId, domainIds, hosts, paths, ports);
        }

        public String toString() {
            return "ListApplicationRoutesRequest.ListApplicationRoutesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationId=" + this.applicationId + ", domainIds=" + this.domainIds + ", hosts=" + this.hosts + ", paths=" + this.paths + ", ports=" + this.ports + ")";
        }
    }
}

