/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListApplicationServiceBindingsRequest
extends PaginatedRequest
implements Validatable {
    private final String applicationId;
    private final List<String> serviceInstanceIds;

    ListApplicationServiceBindingsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, String applicationId, List<String> serviceInstanceIds) {
        super(orderDirection, page, resultsPerPage);
        this.applicationId = applicationId;
        this.serviceInstanceIds = serviceInstanceIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        return builder.build();
    }

    public static ListApplicationServiceBindingsRequestBuilder builder() {
        return new ListApplicationServiceBindingsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListApplicationServiceBindingsRequest)) {
            return false;
        }
        ListApplicationServiceBindingsRequest other = (ListApplicationServiceBindingsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        List<String> this$serviceInstanceIds = this.getServiceInstanceIds();
        List<String> other$serviceInstanceIds = other.getServiceInstanceIds();
        return !(this$serviceInstanceIds == null ? other$serviceInstanceIds != null : !((Object)this$serviceInstanceIds).equals(other$serviceInstanceIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListApplicationServiceBindingsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        List<String> $serviceInstanceIds = this.getServiceInstanceIds();
        result = result * 59 + ($serviceInstanceIds == null ? 43 : ((Object)$serviceInstanceIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListApplicationServiceBindingsRequest(super=" + super.toString() + ", applicationId=" + this.getApplicationId() + ", serviceInstanceIds=" + this.getServiceInstanceIds() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @InFilterParameter(value="service_instance_guid")
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }

    public static class ListApplicationServiceBindingsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private String applicationId;
        private ArrayList<String> serviceInstanceIds;

        ListApplicationServiceBindingsRequestBuilder() {
        }

        public ListApplicationServiceBindingsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListApplicationServiceBindingsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListApplicationServiceBindingsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListApplicationServiceBindingsRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public ListApplicationServiceBindingsRequestBuilder serviceInstanceId(String serviceInstanceId) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList();
            }
            this.serviceInstanceIds.add(serviceInstanceId);
            return this;
        }

        public ListApplicationServiceBindingsRequestBuilder serviceInstanceIds(Collection<? extends String> serviceInstanceIds) {
            if (this.serviceInstanceIds == null) {
                this.serviceInstanceIds = new ArrayList();
            }
            this.serviceInstanceIds.addAll(serviceInstanceIds);
            return this;
        }

        public ListApplicationServiceBindingsRequest build() {
            List<String> serviceInstanceIds;
            switch (this.serviceInstanceIds == null ? 0 : this.serviceInstanceIds.size()) {
                case 0: {
                    serviceInstanceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceInstanceIds = Collections.singletonList(this.serviceInstanceIds.get(0));
                    break;
                }
                default: {
                    serviceInstanceIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceInstanceIds));
                }
            }
            return new ListApplicationServiceBindingsRequest(this.orderDirection, this.page, this.resultsPerPage, this.applicationId, serviceInstanceIds);
        }

        public String toString() {
            return "ListApplicationServiceBindingsRequest.ListApplicationServiceBindingsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationId=" + this.applicationId + ", serviceInstanceIds=" + this.serviceInstanceIds + ")";
        }
    }
}

