/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.servicebindings.ServiceBindingResource;

public final class ListApplicationServiceBindingsResponse
extends PaginatedResponse<ServiceBindingResource> {
    ListApplicationServiceBindingsResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<ServiceBindingResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListApplicationServiceBindingsResponseBuilder builder() {
        return new ListApplicationServiceBindingsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListApplicationServiceBindingsResponse)) {
            return false;
        }
        ListApplicationServiceBindingsResponse other = (ListApplicationServiceBindingsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListApplicationServiceBindingsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListApplicationServiceBindingsResponse(super=" + super.toString() + ")";
    }

    public static class ListApplicationServiceBindingsResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<ServiceBindingResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListApplicationServiceBindingsResponseBuilder() {
        }

        public ListApplicationServiceBindingsResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListApplicationServiceBindingsResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListApplicationServiceBindingsResponseBuilder resource(ServiceBindingResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListApplicationServiceBindingsResponseBuilder resources(Collection<? extends ServiceBindingResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListApplicationServiceBindingsResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListApplicationServiceBindingsResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListApplicationServiceBindingsResponse build() {
            List<ServiceBindingResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<ServiceBindingResource>(this.resources));
                }
            }
            return new ListApplicationServiceBindingsResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListApplicationServiceBindingsResponse.ListApplicationServiceBindingsResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

