/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.IsFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListApplicationsRequest
extends PaginatedRequest
implements Validatable {
    private final Boolean diego;
    private final List<String> names;
    private final List<String> organizationIds;
    private final List<String> spaceIds;
    private final List<String> stackIds;

    ListApplicationsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, Boolean diego, List<String> names, List<String> organizationIds, List<String> spaceIds, List<String> stackIds) {
        super(orderDirection, page, resultsPerPage);
        this.diego = diego;
        this.names = names;
        this.organizationIds = organizationIds;
        this.spaceIds = spaceIds;
        this.stackIds = stackIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    public static ListApplicationsRequestBuilder builder() {
        return new ListApplicationsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListApplicationsRequest)) {
            return false;
        }
        ListApplicationsRequest other = (ListApplicationsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$diego = this.getDiego();
        Boolean other$diego = other.getDiego();
        if (this$diego == null ? other$diego != null : !((Object)this$diego).equals(other$diego)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<String> this$organizationIds = this.getOrganizationIds();
        List<String> other$organizationIds = other.getOrganizationIds();
        if (this$organizationIds == null ? other$organizationIds != null : !((Object)this$organizationIds).equals(other$organizationIds)) {
            return false;
        }
        List<String> this$spaceIds = this.getSpaceIds();
        List<String> other$spaceIds = other.getSpaceIds();
        if (this$spaceIds == null ? other$spaceIds != null : !((Object)this$spaceIds).equals(other$spaceIds)) {
            return false;
        }
        List<String> this$stackIds = this.getStackIds();
        List<String> other$stackIds = other.getStackIds();
        return !(this$stackIds == null ? other$stackIds != null : !((Object)this$stackIds).equals(other$stackIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListApplicationsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Boolean $diego = this.getDiego();
        result = result * 59 + ($diego == null ? 43 : ((Object)$diego).hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<String> $organizationIds = this.getOrganizationIds();
        result = result * 59 + ($organizationIds == null ? 43 : ((Object)$organizationIds).hashCode());
        List<String> $spaceIds = this.getSpaceIds();
        result = result * 59 + ($spaceIds == null ? 43 : ((Object)$spaceIds).hashCode());
        List<String> $stackIds = this.getStackIds();
        result = result * 59 + ($stackIds == null ? 43 : ((Object)$stackIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListApplicationsRequest(super=" + super.toString() + ", diego=" + this.getDiego() + ", names=" + this.getNames() + ", organizationIds=" + this.getOrganizationIds() + ", spaceIds=" + this.getSpaceIds() + ", stackIds=" + this.getStackIds() + ")";
    }

    @IsFilterParameter(value="diego")
    public Boolean getDiego() {
        return this.diego;
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    @InFilterParameter(value="organization_guid")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @InFilterParameter(value="space_guid")
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @InFilterParameter(value="stack_guid")
    public List<String> getStackIds() {
        return this.stackIds;
    }

    public static class ListApplicationsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private Boolean diego;
        private ArrayList<String> names;
        private ArrayList<String> organizationIds;
        private ArrayList<String> spaceIds;
        private ArrayList<String> stackIds;

        ListApplicationsRequestBuilder() {
        }

        public ListApplicationsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListApplicationsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListApplicationsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListApplicationsRequestBuilder diego(Boolean diego) {
            this.diego = diego;
            return this;
        }

        public ListApplicationsRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListApplicationsRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListApplicationsRequestBuilder organizationId(String organizationId) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.add(organizationId);
            return this;
        }

        public ListApplicationsRequestBuilder organizationIds(Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        public ListApplicationsRequestBuilder spaceId(String spaceId) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.add(spaceId);
            return this;
        }

        public ListApplicationsRequestBuilder spaceIds(Collection<? extends String> spaceIds) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.addAll(spaceIds);
            return this;
        }

        public ListApplicationsRequestBuilder stackId(String stackId) {
            if (this.stackIds == null) {
                this.stackIds = new ArrayList();
            }
            this.stackIds.add(stackId);
            return this;
        }

        public ListApplicationsRequestBuilder stackIds(Collection<? extends String> stackIds) {
            if (this.stackIds == null) {
                this.stackIds = new ArrayList();
            }
            this.stackIds.addAll(stackIds);
            return this;
        }

        public ListApplicationsRequest build() {
            List<String> stackIds;
            List<String> spaceIds;
            List<String> organizationIds;
            List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
                case 0: {
                    organizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    organizationIds = Collections.singletonList(this.organizationIds.get(0));
                    break;
                }
                default: {
                    organizationIds = Collections.unmodifiableList(new ArrayList<String>(this.organizationIds));
                }
            }
            switch (this.spaceIds == null ? 0 : this.spaceIds.size()) {
                case 0: {
                    spaceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    spaceIds = Collections.singletonList(this.spaceIds.get(0));
                    break;
                }
                default: {
                    spaceIds = Collections.unmodifiableList(new ArrayList<String>(this.spaceIds));
                }
            }
            switch (this.stackIds == null ? 0 : this.stackIds.size()) {
                case 0: {
                    stackIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    stackIds = Collections.singletonList(this.stackIds.get(0));
                    break;
                }
                default: {
                    stackIds = Collections.unmodifiableList(new ArrayList<String>(this.stackIds));
                }
            }
            return new ListApplicationsRequest(this.orderDirection, this.page, this.resultsPerPage, this.diego, names, organizationIds, spaceIds, stackIds);
        }

        public String toString() {
            return "ListApplicationsRequest.ListApplicationsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", diego=" + this.diego + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", spaceIds=" + this.spaceIds + ", stackIds=" + this.stackIds + ")";
        }
    }
}

