/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class RemoveApplicationServiceBindingRequest
implements Validatable {
    private final String applicationId;
    private final String serviceBindingId;

    RemoveApplicationServiceBindingRequest(String applicationId, String serviceBindingId) {
        this.applicationId = applicationId;
        this.serviceBindingId = serviceBindingId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.serviceBindingId == null) {
            builder.message("service binding id must be specified");
        }
        return builder.build();
    }

    public static RemoveApplicationServiceBindingRequestBuilder builder() {
        return new RemoveApplicationServiceBindingRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveApplicationServiceBindingRequest)) {
            return false;
        }
        RemoveApplicationServiceBindingRequest other = (RemoveApplicationServiceBindingRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$serviceBindingId = this.getServiceBindingId();
        String other$serviceBindingId = other.getServiceBindingId();
        return !(this$serviceBindingId == null ? other$serviceBindingId != null : !this$serviceBindingId.equals(other$serviceBindingId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $serviceBindingId = this.getServiceBindingId();
        result = result * 59 + ($serviceBindingId == null ? 43 : $serviceBindingId.hashCode());
        return result;
    }

    public String toString() {
        return "RemoveApplicationServiceBindingRequest(applicationId=" + this.getApplicationId() + ", serviceBindingId=" + this.getServiceBindingId() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonIgnore
    public String getServiceBindingId() {
        return this.serviceBindingId;
    }

    public static class RemoveApplicationServiceBindingRequestBuilder {
        private String applicationId;
        private String serviceBindingId;

        RemoveApplicationServiceBindingRequestBuilder() {
        }

        public RemoveApplicationServiceBindingRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public RemoveApplicationServiceBindingRequestBuilder serviceBindingId(String serviceBindingId) {
            this.serviceBindingId = serviceBindingId;
            return this;
        }

        public RemoveApplicationServiceBindingRequest build() {
            return new RemoveApplicationServiceBindingRequest(this.applicationId, this.serviceBindingId);
        }

        public String toString() {
            return "RemoveApplicationServiceBindingRequest.RemoveApplicationServiceBindingRequestBuilder(applicationId=" + this.applicationId + ", serviceBindingId=" + this.serviceBindingId + ")";
        }
    }
}

