/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.v2.applications.AbstractApplicationEntity;
import org.cloudfoundry.client.v2.domains.Domain;
import org.cloudfoundry.client.v2.routes.Route;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstance;

public final class SummaryApplicationResponse
extends AbstractApplicationEntity {
    private final List<Domain> availableDomains;
    private final String detectedBuildpack;
    private final Boolean enableSsh;
    private final String id;
    private final String packageState;
    private final String packageUpdatedAt;
    private final List<Integer> ports;
    private final List<Route> routes;
    private final Integer runningInstances;
    private final List<ServiceInstance> services;
    private final String stagingTaskId;
    private final String version;

    SummaryApplicationResponse(@JsonProperty(value="available_domains") List<Domain> availableDomains, @JsonProperty(value="buildpack") String buildpack, @JsonProperty(value="command") String command, @JsonProperty(value="console") @Deprecated Boolean console, @JsonProperty(value="debug") @Deprecated Boolean debug, @JsonProperty(value="detected_buildpack") String detectedBuildpack, @JsonProperty(value="detected_start_command") String detectedStartCommand, @JsonProperty(value="diego") Boolean diego, @JsonProperty(value="disk_quota") Integer diskQuota, @JsonProperty(value="docker_credentials_json") Map<String, Object> dockerCredentialsJsons, @JsonProperty(value="docker_image") String dockerImage, @JsonProperty(value="enable_ssh") Boolean enableSsh, @JsonProperty(value="environment_json") Map<String, Object> environmentJsons, @JsonProperty(value="health_check_timeout") Integer healthCheckTimeout, @JsonProperty(value="health_check_type") String healthCheckType, @JsonProperty(value="guid") String id, @JsonProperty(value="instances") Integer instances, @JsonProperty(value="memory") Integer memory, @JsonProperty(value="name") String name, @JsonProperty(value="package_state") String packageState, @JsonProperty(value="ports") List<Integer> ports, @JsonProperty(value="package_updated_at") String packageUpdatedAt, @JsonProperty(value="production") @Deprecated Boolean production, @JsonProperty(value="routes") List<Route> routes, @JsonProperty(value="running_instances") Integer runningInstances, @JsonProperty(value="services") List<ServiceInstance> services, @JsonProperty(value="space_guid") String spaceId, @JsonProperty(value="stack_guid") String stackId, @JsonProperty(value="staging_failed_description") String stagingFailedDescription, @JsonProperty(value="staging_failed_reason") String stagingFailedReason, @JsonProperty(value="staging_task_id") String stagingTaskId, @JsonProperty(value="state") String state, @JsonProperty(value="version") String version) {
        super(buildpack, command, console, debug, detectedStartCommand, diego, diskQuota, dockerCredentialsJsons, dockerImage, environmentJsons, healthCheckTimeout, healthCheckType, instances, memory, name, production, spaceId, stackId, stagingFailedDescription, stagingFailedReason, state);
        this.availableDomains = availableDomains;
        this.detectedBuildpack = detectedBuildpack;
        this.enableSsh = enableSsh;
        this.id = id;
        this.packageState = packageState;
        this.packageUpdatedAt = packageUpdatedAt;
        this.ports = ports;
        this.routes = routes;
        this.runningInstances = runningInstances;
        this.services = services;
        this.stagingTaskId = stagingTaskId;
        this.version = version;
    }

    public static SummaryApplicationResponseBuilder builder() {
        return new SummaryApplicationResponseBuilder();
    }

    public List<Domain> getAvailableDomains() {
        return this.availableDomains;
    }

    public String getDetectedBuildpack() {
        return this.detectedBuildpack;
    }

    public Boolean getEnableSsh() {
        return this.enableSsh;
    }

    public String getId() {
        return this.id;
    }

    public String getPackageState() {
        return this.packageState;
    }

    public String getPackageUpdatedAt() {
        return this.packageUpdatedAt;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public List<Route> getRoutes() {
        return this.routes;
    }

    public Integer getRunningInstances() {
        return this.runningInstances;
    }

    public List<ServiceInstance> getServices() {
        return this.services;
    }

    public String getStagingTaskId() {
        return this.stagingTaskId;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SummaryApplicationResponse)) {
            return false;
        }
        SummaryApplicationResponse other = (SummaryApplicationResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Domain> this$availableDomains = this.getAvailableDomains();
        List<Domain> other$availableDomains = other.getAvailableDomains();
        if (this$availableDomains == null ? other$availableDomains != null : !((Object)this$availableDomains).equals(other$availableDomains)) {
            return false;
        }
        String this$detectedBuildpack = this.getDetectedBuildpack();
        String other$detectedBuildpack = other.getDetectedBuildpack();
        if (this$detectedBuildpack == null ? other$detectedBuildpack != null : !this$detectedBuildpack.equals(other$detectedBuildpack)) {
            return false;
        }
        Boolean this$enableSsh = this.getEnableSsh();
        Boolean other$enableSsh = other.getEnableSsh();
        if (this$enableSsh == null ? other$enableSsh != null : !((Object)this$enableSsh).equals(other$enableSsh)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$packageState = this.getPackageState();
        String other$packageState = other.getPackageState();
        if (this$packageState == null ? other$packageState != null : !this$packageState.equals(other$packageState)) {
            return false;
        }
        String this$packageUpdatedAt = this.getPackageUpdatedAt();
        String other$packageUpdatedAt = other.getPackageUpdatedAt();
        if (this$packageUpdatedAt == null ? other$packageUpdatedAt != null : !this$packageUpdatedAt.equals(other$packageUpdatedAt)) {
            return false;
        }
        List<Integer> this$ports = this.getPorts();
        List<Integer> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        List<Route> this$routes = this.getRoutes();
        List<Route> other$routes = other.getRoutes();
        if (this$routes == null ? other$routes != null : !((Object)this$routes).equals(other$routes)) {
            return false;
        }
        Integer this$runningInstances = this.getRunningInstances();
        Integer other$runningInstances = other.getRunningInstances();
        if (this$runningInstances == null ? other$runningInstances != null : !((Object)this$runningInstances).equals(other$runningInstances)) {
            return false;
        }
        List<ServiceInstance> this$services = this.getServices();
        List<ServiceInstance> other$services = other.getServices();
        if (this$services == null ? other$services != null : !((Object)this$services).equals(other$services)) {
            return false;
        }
        String this$stagingTaskId = this.getStagingTaskId();
        String other$stagingTaskId = other.getStagingTaskId();
        if (this$stagingTaskId == null ? other$stagingTaskId != null : !this$stagingTaskId.equals(other$stagingTaskId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SummaryApplicationResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<Domain> $availableDomains = this.getAvailableDomains();
        result = result * 59 + ($availableDomains == null ? 43 : ((Object)$availableDomains).hashCode());
        String $detectedBuildpack = this.getDetectedBuildpack();
        result = result * 59 + ($detectedBuildpack == null ? 43 : $detectedBuildpack.hashCode());
        Boolean $enableSsh = this.getEnableSsh();
        result = result * 59 + ($enableSsh == null ? 43 : ((Object)$enableSsh).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $packageState = this.getPackageState();
        result = result * 59 + ($packageState == null ? 43 : $packageState.hashCode());
        String $packageUpdatedAt = this.getPackageUpdatedAt();
        result = result * 59 + ($packageUpdatedAt == null ? 43 : $packageUpdatedAt.hashCode());
        List<Integer> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        List<Route> $routes = this.getRoutes();
        result = result * 59 + ($routes == null ? 43 : ((Object)$routes).hashCode());
        Integer $runningInstances = this.getRunningInstances();
        result = result * 59 + ($runningInstances == null ? 43 : ((Object)$runningInstances).hashCode());
        List<ServiceInstance> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        String $stagingTaskId = this.getStagingTaskId();
        result = result * 59 + ($stagingTaskId == null ? 43 : $stagingTaskId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SummaryApplicationResponse(super=" + super.toString() + ", availableDomains=" + this.getAvailableDomains() + ", detectedBuildpack=" + this.getDetectedBuildpack() + ", enableSsh=" + this.getEnableSsh() + ", id=" + this.getId() + ", packageState=" + this.getPackageState() + ", packageUpdatedAt=" + this.getPackageUpdatedAt() + ", ports=" + this.getPorts() + ", routes=" + this.getRoutes() + ", runningInstances=" + this.getRunningInstances() + ", services=" + this.getServices() + ", stagingTaskId=" + this.getStagingTaskId() + ", version=" + this.getVersion() + ")";
    }

    public static class SummaryApplicationResponseBuilder {
        private ArrayList<Domain> availableDomains;
        private String buildpack;
        private String command;
        private Boolean console;
        private Boolean debug;
        private String detectedBuildpack;
        private String detectedStartCommand;
        private Boolean diego;
        private Integer diskQuota;
        private ArrayList<String> dockerCredentialsJsons$key;
        private ArrayList<Object> dockerCredentialsJsons$value;
        private String dockerImage;
        private Boolean enableSsh;
        private ArrayList<String> environmentJsons$key;
        private ArrayList<Object> environmentJsons$value;
        private Integer healthCheckTimeout;
        private String healthCheckType;
        private String id;
        private Integer instances;
        private Integer memory;
        private String name;
        private String packageState;
        private ArrayList<Integer> ports;
        private String packageUpdatedAt;
        private Boolean production;
        private ArrayList<Route> routes;
        private Integer runningInstances;
        private ArrayList<ServiceInstance> services;
        private String spaceId;
        private String stackId;
        private String stagingFailedDescription;
        private String stagingFailedReason;
        private String stagingTaskId;
        private String state;
        private String version;

        SummaryApplicationResponseBuilder() {
        }

        public SummaryApplicationResponseBuilder availableDomain(Domain availableDomain) {
            if (this.availableDomains == null) {
                this.availableDomains = new ArrayList();
            }
            this.availableDomains.add(availableDomain);
            return this;
        }

        public SummaryApplicationResponseBuilder availableDomains(Collection<? extends Domain> availableDomains) {
            if (this.availableDomains == null) {
                this.availableDomains = new ArrayList();
            }
            this.availableDomains.addAll(availableDomains);
            return this;
        }

        public SummaryApplicationResponseBuilder buildpack(String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        public SummaryApplicationResponseBuilder command(String command) {
            this.command = command;
            return this;
        }

        public SummaryApplicationResponseBuilder console(Boolean console) {
            this.console = console;
            return this;
        }

        public SummaryApplicationResponseBuilder debug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public SummaryApplicationResponseBuilder detectedBuildpack(String detectedBuildpack) {
            this.detectedBuildpack = detectedBuildpack;
            return this;
        }

        public SummaryApplicationResponseBuilder detectedStartCommand(String detectedStartCommand) {
            this.detectedStartCommand = detectedStartCommand;
            return this;
        }

        public SummaryApplicationResponseBuilder diego(Boolean diego) {
            this.diego = diego;
            return this;
        }

        public SummaryApplicationResponseBuilder diskQuota(Integer diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        public SummaryApplicationResponseBuilder dockerCredentialsJson(String dockerCredentialsJsonKey, Object dockerCredentialsJsonValue) {
            if (this.dockerCredentialsJsons$key == null) {
                this.dockerCredentialsJsons$key = new ArrayList();
                this.dockerCredentialsJsons$value = new ArrayList();
            }
            this.dockerCredentialsJsons$key.add(dockerCredentialsJsonKey);
            this.dockerCredentialsJsons$value.add(dockerCredentialsJsonValue);
            return this;
        }

        public SummaryApplicationResponseBuilder dockerCredentialsJsons(Map<? extends String, ? extends Object> dockerCredentialsJsons) {
            if (this.dockerCredentialsJsons$key == null) {
                this.dockerCredentialsJsons$key = new ArrayList();
                this.dockerCredentialsJsons$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : dockerCredentialsJsons.entrySet()) {
                this.dockerCredentialsJsons$key.add($lombokEntry.getKey());
                this.dockerCredentialsJsons$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SummaryApplicationResponseBuilder dockerImage(String dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        public SummaryApplicationResponseBuilder enableSsh(Boolean enableSsh) {
            this.enableSsh = enableSsh;
            return this;
        }

        public SummaryApplicationResponseBuilder environmentJson(String environmentJsonKey, Object environmentJsonValue) {
            if (this.environmentJsons$key == null) {
                this.environmentJsons$key = new ArrayList();
                this.environmentJsons$value = new ArrayList();
            }
            this.environmentJsons$key.add(environmentJsonKey);
            this.environmentJsons$value.add(environmentJsonValue);
            return this;
        }

        public SummaryApplicationResponseBuilder environmentJsons(Map<? extends String, ? extends Object> environmentJsons) {
            if (this.environmentJsons$key == null) {
                this.environmentJsons$key = new ArrayList();
                this.environmentJsons$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : environmentJsons.entrySet()) {
                this.environmentJsons$key.add($lombokEntry.getKey());
                this.environmentJsons$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SummaryApplicationResponseBuilder healthCheckTimeout(Integer healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
            return this;
        }

        public SummaryApplicationResponseBuilder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public SummaryApplicationResponseBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SummaryApplicationResponseBuilder instances(Integer instances) {
            this.instances = instances;
            return this;
        }

        public SummaryApplicationResponseBuilder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public SummaryApplicationResponseBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SummaryApplicationResponseBuilder packageState(String packageState) {
            this.packageState = packageState;
            return this;
        }

        public SummaryApplicationResponseBuilder port(Integer port) {
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.add(port);
            return this;
        }

        public SummaryApplicationResponseBuilder ports(Collection<? extends Integer> ports) {
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.addAll(ports);
            return this;
        }

        public SummaryApplicationResponseBuilder packageUpdatedAt(String packageUpdatedAt) {
            this.packageUpdatedAt = packageUpdatedAt;
            return this;
        }

        public SummaryApplicationResponseBuilder production(Boolean production) {
            this.production = production;
            return this;
        }

        public SummaryApplicationResponseBuilder route(Route route) {
            if (this.routes == null) {
                this.routes = new ArrayList();
            }
            this.routes.add(route);
            return this;
        }

        public SummaryApplicationResponseBuilder routes(Collection<? extends Route> routes) {
            if (this.routes == null) {
                this.routes = new ArrayList();
            }
            this.routes.addAll(routes);
            return this;
        }

        public SummaryApplicationResponseBuilder runningInstances(Integer runningInstances) {
            this.runningInstances = runningInstances;
            return this;
        }

        public SummaryApplicationResponseBuilder service(ServiceInstance service) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.add(service);
            return this;
        }

        public SummaryApplicationResponseBuilder services(Collection<? extends ServiceInstance> services) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.addAll(services);
            return this;
        }

        public SummaryApplicationResponseBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public SummaryApplicationResponseBuilder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public SummaryApplicationResponseBuilder stagingFailedDescription(String stagingFailedDescription) {
            this.stagingFailedDescription = stagingFailedDescription;
            return this;
        }

        public SummaryApplicationResponseBuilder stagingFailedReason(String stagingFailedReason) {
            this.stagingFailedReason = stagingFailedReason;
            return this;
        }

        public SummaryApplicationResponseBuilder stagingTaskId(String stagingTaskId) {
            this.stagingTaskId = stagingTaskId;
            return this;
        }

        public SummaryApplicationResponseBuilder state(String state) {
            this.state = state;
            return this;
        }

        public SummaryApplicationResponseBuilder version(String version) {
            this.version = version;
            return this;
        }

        public SummaryApplicationResponse build() {
            List<ServiceInstance> services;
            List<Route> routes;
            List<Integer> ports;
            Map<Object, Object> environmentJsons;
            Map<Object, Object> dockerCredentialsJsons;
            List<Domain> availableDomains;
            switch (this.availableDomains == null ? 0 : this.availableDomains.size()) {
                case 0: {
                    availableDomains = Collections.emptyList();
                    break;
                }
                case 1: {
                    availableDomains = Collections.singletonList(this.availableDomains.get(0));
                    break;
                }
                default: {
                    availableDomains = Collections.unmodifiableList(new ArrayList<Domain>(this.availableDomains));
                }
            }
            switch (this.dockerCredentialsJsons$key == null ? 0 : this.dockerCredentialsJsons$key.size()) {
                case 0: {
                    dockerCredentialsJsons = Collections.emptyMap();
                    break;
                }
                case 1: {
                    dockerCredentialsJsons = Collections.singletonMap(this.dockerCredentialsJsons$key.get(0), this.dockerCredentialsJsons$value.get(0));
                    break;
                }
                default: {
                    dockerCredentialsJsons = new LinkedHashMap(this.dockerCredentialsJsons$key.size() < 0x40000000 ? 1 + this.dockerCredentialsJsons$key.size() + (this.dockerCredentialsJsons$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.dockerCredentialsJsons$key.size(); ++$i) {
                        dockerCredentialsJsons.put(this.dockerCredentialsJsons$key.get($i), this.dockerCredentialsJsons$value.get($i));
                    }
                    dockerCredentialsJsons = Collections.unmodifiableMap(dockerCredentialsJsons);
                }
            }
            switch (this.environmentJsons$key == null ? 0 : this.environmentJsons$key.size()) {
                case 0: {
                    environmentJsons = Collections.emptyMap();
                    break;
                }
                case 1: {
                    environmentJsons = Collections.singletonMap(this.environmentJsons$key.get(0), this.environmentJsons$value.get(0));
                    break;
                }
                default: {
                    environmentJsons = new LinkedHashMap(this.environmentJsons$key.size() < 0x40000000 ? 1 + this.environmentJsons$key.size() + (this.environmentJsons$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.environmentJsons$key.size(); ++$i) {
                        environmentJsons.put(this.environmentJsons$key.get($i), this.environmentJsons$value.get($i));
                    }
                    environmentJsons = Collections.unmodifiableMap(environmentJsons);
                }
            }
            switch (this.ports == null ? 0 : this.ports.size()) {
                case 0: {
                    ports = Collections.emptyList();
                    break;
                }
                case 1: {
                    ports = Collections.singletonList(this.ports.get(0));
                    break;
                }
                default: {
                    ports = Collections.unmodifiableList(new ArrayList<Integer>(this.ports));
                }
            }
            switch (this.routes == null ? 0 : this.routes.size()) {
                case 0: {
                    routes = Collections.emptyList();
                    break;
                }
                case 1: {
                    routes = Collections.singletonList(this.routes.get(0));
                    break;
                }
                default: {
                    routes = Collections.unmodifiableList(new ArrayList<Route>(this.routes));
                }
            }
            switch (this.services == null ? 0 : this.services.size()) {
                case 0: {
                    services = Collections.emptyList();
                    break;
                }
                case 1: {
                    services = Collections.singletonList(this.services.get(0));
                    break;
                }
                default: {
                    services = Collections.unmodifiableList(new ArrayList<ServiceInstance>(this.services));
                }
            }
            return new SummaryApplicationResponse(availableDomains, this.buildpack, this.command, this.console, this.debug, this.detectedBuildpack, this.detectedStartCommand, this.diego, this.diskQuota, dockerCredentialsJsons, this.dockerImage, this.enableSsh, environmentJsons, this.healthCheckTimeout, this.healthCheckType, this.id, this.instances, this.memory, this.name, this.packageState, ports, this.packageUpdatedAt, this.production, routes, this.runningInstances, services, this.spaceId, this.stackId, this.stagingFailedDescription, this.stagingFailedReason, this.stagingTaskId, this.state, this.version);
        }

        public String toString() {
            return "SummaryApplicationResponse.SummaryApplicationResponseBuilder(availableDomains=" + this.availableDomains + ", buildpack=" + this.buildpack + ", command=" + this.command + ", console=" + this.console + ", debug=" + this.debug + ", detectedBuildpack=" + this.detectedBuildpack + ", detectedStartCommand=" + this.detectedStartCommand + ", diego=" + this.diego + ", diskQuota=" + this.diskQuota + ", dockerCredentialsJsons$key=" + this.dockerCredentialsJsons$key + ", dockerCredentialsJsons$value=" + this.dockerCredentialsJsons$value + ", dockerImage=" + this.dockerImage + ", enableSsh=" + this.enableSsh + ", environmentJsons$key=" + this.environmentJsons$key + ", environmentJsons$value=" + this.environmentJsons$value + ", healthCheckTimeout=" + this.healthCheckTimeout + ", healthCheckType=" + this.healthCheckType + ", id=" + this.id + ", instances=" + this.instances + ", memory=" + this.memory + ", name=" + this.name + ", packageState=" + this.packageState + ", ports=" + this.ports + ", packageUpdatedAt=" + this.packageUpdatedAt + ", production=" + this.production + ", routes=" + this.routes + ", runningInstances=" + this.runningInstances + ", services=" + this.services + ", spaceId=" + this.spaceId + ", stackId=" + this.stackId + ", stagingFailedDescription=" + this.stagingFailedDescription + ", stagingFailedReason=" + this.stagingFailedReason + ", stagingTaskId=" + this.stagingTaskId + ", state=" + this.state + ", version=" + this.version + ")";
        }
    }
}

