/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class TerminateApplicationInstanceRequest
implements Validatable {
    private final String applicationId;
    private final String index;

    TerminateApplicationInstanceRequest(String applicationId, String index) {
        this.applicationId = applicationId;
        this.index = index;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.index == null) {
            builder.message("index must be specified");
        }
        return builder.build();
    }

    public static TerminateApplicationInstanceRequestBuilder builder() {
        return new TerminateApplicationInstanceRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TerminateApplicationInstanceRequest)) {
            return false;
        }
        TerminateApplicationInstanceRequest other = (TerminateApplicationInstanceRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        return !(this$index == null ? other$index != null : !this$index.equals(other$index));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        return result;
    }

    public String toString() {
        return "TerminateApplicationInstanceRequest(applicationId=" + this.getApplicationId() + ", index=" + this.getIndex() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonIgnore
    public String getIndex() {
        return this.index;
    }

    public static class TerminateApplicationInstanceRequestBuilder {
        private String applicationId;
        private String index;

        TerminateApplicationInstanceRequestBuilder() {
        }

        public TerminateApplicationInstanceRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public TerminateApplicationInstanceRequestBuilder index(String index) {
            this.index = index;
            return this;
        }

        public TerminateApplicationInstanceRequest build() {
            return new TerminateApplicationInstanceRequest(this.applicationId, this.index);
        }

        public String toString() {
            return "TerminateApplicationInstanceRequest.TerminateApplicationInstanceRequestBuilder(applicationId=" + this.applicationId + ", index=" + this.index + ")";
        }
    }
}

