/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UploadApplicationRequest
implements Validatable {
    private final InputStream application;
    private final String applicationId;
    private final Boolean async;
    private final List<Resource> resources;

    UploadApplicationRequest(InputStream application, String applicationId, Boolean async, List<Resource> resources) {
        this.application = application;
        this.applicationId = applicationId;
        this.async = async;
        this.resources = resources;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.application == null) {
            builder.message("application must be specified");
        }
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        for (Resource resource : this.resources) {
            builder.messages(resource.isValid().getMessages());
        }
        return builder.build();
    }

    public static UploadApplicationRequestBuilder builder() {
        return new UploadApplicationRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadApplicationRequest)) {
            return false;
        }
        UploadApplicationRequest other = (UploadApplicationRequest)o;
        InputStream this$application = this.getApplication();
        InputStream other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        Boolean this$async = this.getAsync();
        Boolean other$async = other.getAsync();
        if (this$async == null ? other$async != null : !((Object)this$async).equals(other$async)) {
            return false;
        }
        List<Resource> this$resources = this.getResources();
        List<Resource> other$resources = other.getResources();
        return !(this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InputStream $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        Boolean $async = this.getAsync();
        result = result * 59 + ($async == null ? 43 : ((Object)$async).hashCode());
        List<Resource> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        return result;
    }

    public String toString() {
        return "UploadApplicationRequest(application=" + this.getApplication() + ", applicationId=" + this.getApplicationId() + ", async=" + this.getAsync() + ", resources=" + this.getResources() + ")";
    }

    @JsonIgnore
    public InputStream getApplication() {
        return this.application;
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @QueryParameter(value="async")
    public Boolean getAsync() {
        return this.async;
    }

    @JsonIgnore
    public List<Resource> getResources() {
        return this.resources;
    }

    public static class UploadApplicationRequestBuilder {
        private InputStream application;
        private String applicationId;
        private Boolean async;
        private ArrayList<Resource> resources;

        UploadApplicationRequestBuilder() {
        }

        public UploadApplicationRequestBuilder application(InputStream application) {
            this.application = application;
            return this;
        }

        public UploadApplicationRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public UploadApplicationRequestBuilder async(Boolean async) {
            this.async = async;
            return this;
        }

        public UploadApplicationRequestBuilder resource(Resource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public UploadApplicationRequestBuilder resources(Collection<? extends Resource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public UploadApplicationRequest build() {
            List<Resource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<Resource>(this.resources));
                }
            }
            return new UploadApplicationRequest(this.application, this.applicationId, this.async, resources);
        }

        public String toString() {
            return "UploadApplicationRequest.UploadApplicationRequestBuilder(application=" + this.application + ", applicationId=" + this.applicationId + ", async=" + this.async + ", resources=" + this.resources + ")";
        }
    }

    public static final class Resource
    implements Validatable {
        private final String hash;
        private final String path;
        private final Integer size;

        Resource(String hash, String path, Integer size) {
            this.path = path;
            this.hash = hash;
            this.size = size;
        }

        @Override
        public ValidationResult isValid() {
            ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
            if (this.hash == null) {
                builder.message("resource hash must be specified");
            }
            if (this.path == null) {
                builder.message("resource path must be specified");
            }
            if (this.size == null) {
                builder.message("resource size must be specified");
            }
            return builder.build();
        }

        public static ResourceBuilder builder() {
            return new ResourceBuilder();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            Integer this$size = this.getSize();
            Integer other$size = other.getSize();
            return !(this$size == null ? other$size != null : !((Object)this$size).equals(other$size));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            Integer $size = this.getSize();
            result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
            return result;
        }

        public String toString() {
            return "UploadApplicationRequest.Resource(hash=" + this.getHash() + ", path=" + this.getPath() + ", size=" + this.getSize() + ")";
        }

        @JsonProperty(value="sha1")
        public String getHash() {
            return this.hash;
        }

        @JsonProperty(value="fn")
        public String getPath() {
            return this.path;
        }

        @JsonProperty(value="size")
        public Integer getSize() {
            return this.size;
        }

        public static class ResourceBuilder {
            private String hash;
            private String path;
            private Integer size;

            ResourceBuilder() {
            }

            public ResourceBuilder hash(String hash) {
                this.hash = hash;
                return this;
            }

            public ResourceBuilder path(String path) {
                this.path = path;
                return this;
            }

            public ResourceBuilder size(Integer size) {
                this.size = size;
                return this;
            }

            public Resource build() {
                return new Resource(this.hash, this.path, this.size);
            }

            public String toString() {
                return "UploadApplicationRequest.Resource.ResourceBuilder(hash=" + this.hash + ", path=" + this.path + ", size=" + this.size + ")";
            }
        }
    }
}

