/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.applicationusageevents;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.applicationusageevents.ApplicationUsageEventResource;

public final class ListApplicationUsageEventsResponse
extends PaginatedResponse<ApplicationUsageEventResource> {
    ListApplicationUsageEventsResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<ApplicationUsageEventResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListApplicationUsageEventsResponseBuilder builder() {
        return new ListApplicationUsageEventsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListApplicationUsageEventsResponse)) {
            return false;
        }
        ListApplicationUsageEventsResponse other = (ListApplicationUsageEventsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListApplicationUsageEventsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListApplicationUsageEventsResponse(super=" + super.toString() + ")";
    }

    public static class ListApplicationUsageEventsResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<ApplicationUsageEventResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListApplicationUsageEventsResponseBuilder() {
        }

        public ListApplicationUsageEventsResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListApplicationUsageEventsResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListApplicationUsageEventsResponseBuilder resource(ApplicationUsageEventResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListApplicationUsageEventsResponseBuilder resources(Collection<? extends ApplicationUsageEventResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListApplicationUsageEventsResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListApplicationUsageEventsResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListApplicationUsageEventsResponse build() {
            List<ApplicationUsageEventResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<ApplicationUsageEventResource>(this.resources));
                }
            }
            return new ListApplicationUsageEventsResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListApplicationUsageEventsResponse.ListApplicationUsageEventsResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

