/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.buildpacks;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.buildpacks.BuildpackResource;

public final class ListBuildpacksResponse
extends PaginatedResponse<BuildpackResource> {
    ListBuildpacksResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<BuildpackResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListBuildpacksResponseBuilder builder() {
        return new ListBuildpacksResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListBuildpacksResponse)) {
            return false;
        }
        ListBuildpacksResponse other = (ListBuildpacksResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListBuildpacksResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListBuildpacksResponse(super=" + super.toString() + ")";
    }

    public static class ListBuildpacksResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<BuildpackResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListBuildpacksResponseBuilder() {
        }

        public ListBuildpacksResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListBuildpacksResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListBuildpacksResponseBuilder resource(BuildpackResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListBuildpacksResponseBuilder resources(Collection<? extends BuildpackResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListBuildpacksResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListBuildpacksResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListBuildpacksResponse build() {
            List<BuildpackResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<BuildpackResource>(this.resources));
                }
            }
            return new ListBuildpacksResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListBuildpacksResponse.ListBuildpacksResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

