/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.buildpacks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UpdateBuildpackRequest
implements Validatable {
    private final String buildpackId;
    private final Boolean enabled;
    private final String filename;
    private final Boolean locked;
    private final String name;
    private final Integer position;

    UpdateBuildpackRequest(String buildpackId, Boolean enabled, String filename, Boolean locked, String name, Integer position) {
        this.buildpackId = buildpackId;
        this.enabled = enabled;
        this.filename = filename;
        this.locked = locked;
        this.name = name;
        this.position = position;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.buildpackId == null) {
            builder.message("buildpack id must be specified");
        }
        return builder.build();
    }

    public static UpdateBuildpackRequestBuilder builder() {
        return new UpdateBuildpackRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateBuildpackRequest)) {
            return false;
        }
        UpdateBuildpackRequest other = (UpdateBuildpackRequest)o;
        String this$buildpackId = this.getBuildpackId();
        String other$buildpackId = other.getBuildpackId();
        if (this$buildpackId == null ? other$buildpackId != null : !this$buildpackId.equals(other$buildpackId)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        Boolean this$locked = this.getLocked();
        Boolean other$locked = other.getLocked();
        if (this$locked == null ? other$locked != null : !((Object)this$locked).equals(other$locked)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Integer this$position = this.getPosition();
        Integer other$position = other.getPosition();
        return !(this$position == null ? other$position != null : !((Object)this$position).equals(other$position));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $buildpackId = this.getBuildpackId();
        result = result * 59 + ($buildpackId == null ? 43 : $buildpackId.hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        Boolean $locked = this.getLocked();
        result = result * 59 + ($locked == null ? 43 : ((Object)$locked).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Integer $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        return result;
    }

    public String toString() {
        return "UpdateBuildpackRequest(buildpackId=" + this.getBuildpackId() + ", enabled=" + this.getEnabled() + ", filename=" + this.getFilename() + ", locked=" + this.getLocked() + ", name=" + this.getName() + ", position=" + this.getPosition() + ")";
    }

    @JsonIgnore
    public String getBuildpackId() {
        return this.buildpackId;
    }

    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="filename")
    public String getFilename() {
        return this.filename;
    }

    @JsonProperty(value="locked")
    public Boolean getLocked() {
        return this.locked;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="position")
    public Integer getPosition() {
        return this.position;
    }

    public static class UpdateBuildpackRequestBuilder {
        private String buildpackId;
        private Boolean enabled;
        private String filename;
        private Boolean locked;
        private String name;
        private Integer position;

        UpdateBuildpackRequestBuilder() {
        }

        public UpdateBuildpackRequestBuilder buildpackId(String buildpackId) {
            this.buildpackId = buildpackId;
            return this;
        }

        public UpdateBuildpackRequestBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public UpdateBuildpackRequestBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public UpdateBuildpackRequestBuilder locked(Boolean locked) {
            this.locked = locked;
            return this;
        }

        public UpdateBuildpackRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UpdateBuildpackRequestBuilder position(Integer position) {
            this.position = position;
            return this;
        }

        public UpdateBuildpackRequest build() {
            return new UpdateBuildpackRequest(this.buildpackId, this.enabled, this.filename, this.locked, this.name, this.position);
        }

        public String toString() {
            return "UpdateBuildpackRequest.UpdateBuildpackRequestBuilder(buildpackId=" + this.buildpackId + ", enabled=" + this.enabled + ", filename=" + this.filename + ", locked=" + this.locked + ", name=" + this.name + ", position=" + this.position + ")";
        }
    }
}

