/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.buildpacks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UploadBuildpackRequest
implements Validatable {
    private final InputStream buildpack;
    private final String buildpackId;
    private final String filename;

    UploadBuildpackRequest(InputStream buildpack, String buildpackId, String filename) {
        this.buildpack = buildpack;
        this.buildpackId = buildpackId;
        this.filename = filename;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.buildpack == null) {
            builder.message("buildpack must be specified");
        }
        if (this.buildpackId == null) {
            builder.message("buildpack id must be specified");
        }
        if (this.filename == null) {
            builder.message("filename must be specified");
        }
        return builder.build();
    }

    public static UploadBuildpackRequestBuilder builder() {
        return new UploadBuildpackRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadBuildpackRequest)) {
            return false;
        }
        UploadBuildpackRequest other = (UploadBuildpackRequest)o;
        InputStream this$buildpack = this.getBuildpack();
        InputStream other$buildpack = other.getBuildpack();
        if (this$buildpack == null ? other$buildpack != null : !this$buildpack.equals(other$buildpack)) {
            return false;
        }
        String this$buildpackId = this.getBuildpackId();
        String other$buildpackId = other.getBuildpackId();
        if (this$buildpackId == null ? other$buildpackId != null : !this$buildpackId.equals(other$buildpackId)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        return !(this$filename == null ? other$filename != null : !this$filename.equals(other$filename));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InputStream $buildpack = this.getBuildpack();
        result = result * 59 + ($buildpack == null ? 43 : $buildpack.hashCode());
        String $buildpackId = this.getBuildpackId();
        result = result * 59 + ($buildpackId == null ? 43 : $buildpackId.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        return result;
    }

    public String toString() {
        return "UploadBuildpackRequest(buildpack=" + this.getBuildpack() + ", buildpackId=" + this.getBuildpackId() + ", filename=" + this.getFilename() + ")";
    }

    @JsonIgnore
    public InputStream getBuildpack() {
        return this.buildpack;
    }

    @JsonIgnore
    public String getBuildpackId() {
        return this.buildpackId;
    }

    @JsonIgnore
    public String getFilename() {
        return this.filename;
    }

    public static class UploadBuildpackRequestBuilder {
        private InputStream buildpack;
        private String buildpackId;
        private String filename;

        UploadBuildpackRequestBuilder() {
        }

        public UploadBuildpackRequestBuilder buildpack(InputStream buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        public UploadBuildpackRequestBuilder buildpackId(String buildpackId) {
            this.buildpackId = buildpackId;
            return this;
        }

        public UploadBuildpackRequestBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public UploadBuildpackRequest build() {
            return new UploadBuildpackRequest(this.buildpack, this.buildpackId, this.filename);
        }

        public String toString() {
            return "UploadBuildpackRequest.UploadBuildpackRequestBuilder(buildpack=" + this.buildpack + ", buildpackId=" + this.buildpackId + ", filename=" + this.filename + ")";
        }
    }
}

